#ifndef _TAP_H
#define _TAP_H

/*
 * Copyright (C) 2005 by egnite Software GmbH
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

/*!
 * \file tap.h
 *
 * \verbatim
 *
 * $Log: tap.h,v $
 * Revision 1.1.1.1  2005/09/14 09:01:09  haraldkipp
 * Initial import.
 *
 *
 * \endverbatim
 */

/* Low level functions provided by port driver. */
extern int TapInit(char *devname);
extern void TapExit(void);

extern void TapReset(int s);
extern void TapTdi(int s);
extern int TapTdo(void);
extern void TapNext(int s);

/* General functions. */
extern void TapIdle(void);
extern void TapData(unsigned char *rbuf, const unsigned char *wbuf, int len);
extern void TapInstruction(unsigned long code);

#endif
