#include "stdafx.h"
#include "MyMoney.h"
#include "MyMoneyDlg.h"
#include "StockEditDlg.h"
#include  "stock.h"
#include "gui.h"
#include "ListCtrlStyled.h"

extern HANDLE Semaph;

LIVE_STOCK_LIST1 StockList1[30]={ /*don't change the array order, but can change its index */
	{"Name",			0, 65, RGB(255,255,255), LVCFMT_LEFT}, /*must be first one, other index can be changed*/
	{"Rmk",				1, 20, RGB(255,255,255), LVCFMT_LEFT},
	{"Last",			2, 40, RGB(255,255,10), LVCFMT_RIGHT},
	{"Change",			3, 40, RGB(255,255,255), LVCFMT_RIGHT},
	{"%",				4, 40, RGB(255,255,10), LVCFMT_RIGHT},
	{"Vol",				5, 45, RGB(255,255,255), LVCFMT_RIGHT},
	{"B Vol",			6, 45, RGB(255,255,255), LVCFMT_RIGHT},
	{"Buy",				7, 40, RGB(255,255,10), LVCFMT_RIGHT},
	{"Sell",			8, 40, RGB(255,255,10), LVCFMT_RIGHT},
	{"S Vol",			9, 45, RGB(255,255,255), LVCFMT_RIGHT},
	{"High",			10, 40, RGB(255,255,255), LVCFMT_RIGHT},
	{"Low",				11, 40, RGB(255,255,255), LVCFMT_RIGHT},
	{"Sector",			12, 15, RGB(255,255,255), LVCFMT_LEFT},
	{"My Qty",			13, 40, RGB(255,255,255), LVCFMT_RIGHT},
	{"Ave Cost",		14, 40, RGB(255,255,10), LVCFMT_RIGHT},
	{"P/L 1",			15, 40, RGB(255,255,255), LVCFMT_RIGHT},
	{"P/L 2",			16, 40, RGB(255,255,255), LVCFMT_RIGHT},
	{"BuyHopePrice",	17, 40, RGB(255,255,255), LVCFMT_RIGHT},
	{"SellHopePrice",	18, 40, RGB(255,255,255), LVCFMT_RIGHT},
	{"Comments",		19, 250,RGB(255,255,255), LVCFMT_LEFT},
	{"Announce",		20, 250,RGB(255,255,255), LVCFMT_LEFT},

	{NULL,				-1, 0,	RGB(255,255,255), LVCFMT_LEFT} /*end flag */
};

LIVE_STOCK_LIST1 StockList2[30]={ /*don't change the array order, but can change its index */
	{"Name",			0, 60, RGB(255,255,255), LVCFMT_LEFT}, /*must be first one, other index can be changed*/
	{"Rmk",				1, 15, RGB(255,255,255), LVCFMT_LEFT},
	{"Last",			2, 40, RGB(255,255,10), LVCFMT_RIGHT},
	{"Change",			3, 40, RGB(255,255,255), LVCFMT_RIGHT},
	{"%",				4, 40, RGB(255,255,10), LVCFMT_RIGHT},
	{"Vol",				5, 45, RGB(255,255,255), LVCFMT_RIGHT},
	{"B Vol",			6, 40, RGB(255,255,255), LVCFMT_RIGHT},
	{"Buy",				7, 40, RGB(255,255,10), LVCFMT_RIGHT},
	{"Sell",			8, 40, RGB(255,255,10), LVCFMT_RIGHT},
	{"S Vol",			9, 40, RGB(255,255,255), LVCFMT_RIGHT},
	{"High",			10, 40, RGB(255,255,255), LVCFMT_RIGHT},
	{"Low",				11, 40, RGB(255,255,255), LVCFMT_RIGHT},
	{"Sector",			12, 15, RGB(255,255,255), LVCFMT_LEFT},
	//{"My Qty",		13, 40, RGB(255,255,255), LVCFMT_RIGHT},
	//{"Ave Cost",		14, 40, RGB(255,255,10), LVCFMT_RIGHT},
	//{"P/L 1",			15, 40, RGB(255,255,255), LVCFMT_RIGHT},
	//{"P/L 2",			16, 40, RGB(255,255,255), LVCFMT_RIGHT},
	//{"BuyHopePrice",	17, 40, RGB(255,255,255), LVCFMT_RIGHT},
	//{"SellHopePrice",	18, 40, RGB(255,255,255), LVCFMT_RIGHT},
	//{"Comments",		19, 200,RGB(255,255,255), LVCFMT_LEFT},

	{NULL,				-1, 0,	RGB(255,255,255), LVCFMT_LEFT} /*end flag */
};


void InitLiveStockList1(CListCtrlStyled *pList)
{
	int i=0;

#if 1
	pList->SetExtendedStyle(LVS_EX_GRIDLINES | LVS_EX_FLATSB |
      LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES );
#endif
	while( StockList1[i].column_name != NULL )
	{
		pList->InsertColumn(StockList1[i].column_index, 
			StockList1[i].column_name, StockList1[i].style,
			StockList1[i].size );

		pList->SetColStyle(i, LIS_BGCOLOR);
		pList->SetColBgColor(i, StockList1[i].BGColor );

		i++;
	}

	//m_LivePriceList.SetColSelectedBgColor(4, RGB(10, 0, 10));
	
}

void InitLiveStockList2(CListCtrlStyled *pList)
{
	int i=0;

#if 1
	pList->SetExtendedStyle(LVS_EX_GRIDLINES | LVS_EX_FLATSB |
      LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES );
#endif
	while( StockList2[i].column_name != NULL )
	{
		pList->InsertColumn(StockList2[i].column_index, 
			StockList2[i].column_name, StockList2[i].style,
			StockList2[i].size );

		pList->SetColStyle(i, LIS_BGCOLOR /*| LIS_BOLD */);
		pList->SetColBgColor(i, StockList2[i].BGColor );

		i++;
	}	
}


void SetStockListGUI(CListCtrlStyled *pList, int index, int subIndex, char *s)
{
	LV_ITEM lv_item;    
	CString OrigText;

#ifdef NEED_PROTECT
	WaitForSingleObject(Semaph, INFINITE );
#endif
	/*Update GUI */
	int nItemCount = pList->GetItemCount();
	if(subIndex == 0 && index >= nItemCount )
	{	/*not added yet, so need to add into  list */
		lv_item.mask = LVIF_TEXT;
		lv_item.stateMask = LVIS_SELECTED;
		lv_item.iItem = pList->GetItemCount();
		lv_item.iSubItem = subIndex;
		
		if( s != NULL )
			lv_item.pszText = s;
		else
			lv_item.pszText = "";
		lv_item.cchTextMax = strlen(lv_item.pszText) +1 ;

		pList->InsertItem( &lv_item );

		//Set this row can accept color setting
		pList->SetRowStyle(lv_item.iItem,LIS_TXTCOLOR);
		pList->SetRowTxtColor(lv_item.iItem, NORMAL_COLOR);

	}
	else
	{ /*already in list */
		/*not added yet, so need to add into  list */
		lv_item.iItem = index;
		lv_item.iSubItem = subIndex;

#if 1		
		OrigText = pList->GetItemText( index, subIndex);
		if( strcmp(OrigText, s) == 0) //aready same, so no need to set again.
			return;	
#endif

		lv_item.mask = LVIF_TEXT;
		lv_item.stateMask = LVIS_SELECTED;
	    lv_item.pszText = s;
		lv_item.cchTextMax = strlen(lv_item.pszText) +1 ;
		lv_item.mask = LVIF_TEXT | LVIF_PARAM;

		
		pList->SetItem( &lv_item );

		pList->SetItemTxtColor(index, subIndex, RGB(255, 0, 0), FALSE);
		pList->SetItemBgColor(index, subIndex, RGB(0, 255, 0), FALSE);		
	}

#ifdef NEED_PROTECT
	ReleaseSemaphore(Semaph, 1, NULL);
#endif
}

void UpdateStockElement(CListCtrlStyled *pList, int index, StockElement* pStockElement)
{
	char buffer[100];
	char buf1[50], buf2[50];
	
	SetStockListGUI(pList, index, 0, pStockElement->StockInfo1.StockName);

	/*update My stock qty:13*/
	sprintf(buffer, "%d", pStockElement->StockInfo1.Quantity);
	SetStockListGUI(pList, index, 13, buffer);


	/*update My stock cost/Buyin Price:14*/
	sprintf(buffer, "%.03f", pStockElement->StockInfo1.BuyInPrice);
	SetStockListGUI(pList, index, 14, buffer);

	if( Cal_P_L(pStockElement, buf1, buf2) )
	{
		/*update my P/L1:15 */
		SetStockListGUI(pList, index, 15, buf1);

		/*update my P/L2:16 */
		SetStockListGUI(pList, index, 16, buf2);
	}

	/*Buy expected Price:17*/
	sprintf(buffer, "%.03f", pStockElement->StockInfo1.BuyInExpectedPrice);
	SetStockListGUI(pList, index, 17, buffer);

	/*Sell expected Price:18*/
	sprintf(buffer, "%.03f", pStockElement->StockInfo1.SellExpectedPrice);
	SetStockListGUI(pList, index, 18, buffer);

	/*update my comments:19 */
	SetStockListGUI(pList, index, 19, pStockElement->StockInfo1.Comments);	


	/*lastdone: 2 */
	sprintf(buffer, "%.03f", pStockElement->StockInfo2.PriceLastDone);
	SetStockListGUI(pList, index, 2, buffer);

	/*PriceSelling: 7 */
	sprintf(buffer, "%.03f", pStockElement->StockInfo2.PriceBuying);
	SetStockListGUI(pList, index, 7, buffer);

	/*PriceSelling: 8 */
	sprintf(buffer, "%.03f", pStockElement->StockInfo2.PriceSelling);
	SetStockListGUI(pList, index, 8, buffer);

	/*LastAnnounce: 8 */
	pStockElement->StockInfo2.LastAnnounce[sizeof(pStockElement->StockInfo2.LastAnnounce)-1] = 0;
	if( strlen(pStockElement->StockInfo2.LastAnnounce) >= 2) 
	{
		sprintf(buffer, "%.03f", pStockElement->StockInfo2.LastAnnounce);
		SetStockListGUI(pList, index, 20, pStockElement->StockInfo2.LastAnnounce); 
	}


}

