// StockEditDlg.cpp : implementation file
//

#include "stdafx.h"
#include "MyMoney.h"
#include "StockEditDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CStockEditDlg dialog


CStockEditDlg::CStockEditDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CStockEditDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CStockEditDlg)
	m_StockBuyDate = COleDateTime::GetCurrentTime();
	m_StockSoldDate1 = COleDateTime::GetCurrentTime();
	m_StockSoldDate2 = COleDateTime::GetCurrentTime();
	m_StockSoldDate3 = COleDateTime::GetCurrentTime();
	m_Comments = _T("");
	m_SellPrice1 = 0.0f;
	m_SellPrice2 = 0.0f;
	m_SellPrice3 = 0.0f;
	m_BuyInQuantity = 0;
	m_SoldQuantity1 = 0;
	m_SoldQuantity2 = 0;
	m_SoldQuantity3 = 0;
	m_StockName = _T("");
	m_Cost = 0.0f;
	m_Comments2 = _T("");
	m_Comments3 = _T("");
	m_BuyIdealPrice = 0.0f;
	m_SellIdealPrice = 0.0f;
	//}}AFX_DATA_INIT
}


void CStockEditDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CStockEditDlg)
	DDX_DateTimeCtrl(pDX, IDC_DATETIMEPICKER_BUY, m_StockBuyDate);
	DDX_DateTimeCtrl(pDX, IDC_DATETIMEPICKER_SOLD1, m_StockSoldDate1);
	DDX_DateTimeCtrl(pDX, IDC_DATETIMEPICKER_SOLD2, m_StockSoldDate2);
	DDX_DateTimeCtrl(pDX, IDC_DATETIMEPICKER_SOLD3, m_StockSoldDate3);
	DDX_Text(pDX, IDC_EDIT_COMMENTS, m_Comments);
	DDX_Text(pDX, IDC_EDIT_PRICE_SELL1, m_SellPrice1);
	DDX_Text(pDX, IDC_EDIT_PRICE_SELL2, m_SellPrice2);
	DDX_Text(pDX, IDC_EDIT_PRICE_SELL3, m_SellPrice3);
	DDX_Text(pDX, IDC_EDIT_QUANTITY, m_BuyInQuantity);
	DDX_Text(pDX, IDC_EDIT_QUANTITY_SELL1, m_SoldQuantity1);
	DDX_Text(pDX, IDC_EDIT_QUANTITY_SELL2, m_SoldQuantity2);
	DDX_Text(pDX, IDC_EDIT_QUANTITY_SELL3, m_SoldQuantity3);
	DDX_Text(pDX, IDC_EDIT_STOCKNAME, m_StockName);
	DDX_Text(pDX, IDC_EDIT_COST, m_Cost);
	DDX_Text(pDX, IDC_EDIT_COMMENTS2, m_Comments2);
	DDX_Text(pDX, IDC_EDIT_COMMENTS3, m_Comments3);
	DDX_Text(pDX, IDC_EDIT_BuyIdealPRICE, m_BuyIdealPrice);
	DDX_Text(pDX, IDC_EDIT_SellIdealPRICE, m_SellIdealPrice);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CStockEditDlg, CDialog)
	//{{AFX_MSG_MAP(CStockEditDlg)
	ON_BN_CLICKED(ID_EDIT_OK, OnEditOk)
	ON_BN_CLICKED(IDC_BUTTON_SAVE_PRICE, OnButtonSavePrice)
	ON_BN_CLICKED(IDC_BUTTON_SAVE_NEWS, OnButtonSaveNews)
	ON_BN_CLICKED(IDC_BUTTON_SAVE_SOLD_HISTROY, OnButtonSaveSoldHistory)
	ON_EN_CHANGE(IDC_EDIT_COMMENTS, OnChangeEditComments)
	ON_EN_CHANGE(IDC_EDIT_COMMENTS2, OnChangeEditComments2)
	ON_EN_CHANGE(IDC_EDIT_COMMENTS3, OnChangeEditComments3)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CStockEditDlg message handlers


BOOL CStockEditDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_StockBuyDate = stock.StockInfo1.DateBuyIn;
	m_StockSoldDate1 = stock.StockInfo1.DateSold[0];
	m_StockSoldDate2 = stock.StockInfo1.DateSold[1];
	m_StockSoldDate3 = stock.StockInfo1.DateSold[2];
	m_Comments = stock.StockInfo1.Comments;
	m_Comments2 = stock.StockInfo1.Comments2;
	m_Comments3 = stock.StockInfo1.Comments3;
	m_Cost = stock.StockInfo1.BuyInPrice;
	m_SellPrice1 = stock.StockInfo1.SoldPrice[0];
	m_SellPrice2 = stock.StockInfo1.SoldPrice[1];
	m_SellPrice3 = stock.StockInfo1.SoldPrice[2];
	m_BuyInQuantity = stock.StockInfo1.Quantity;
	m_SoldQuantity1 = stock.StockInfo1.QuantitySold[0];
	m_SoldQuantity2 = stock.StockInfo1.QuantitySold[1];
	m_SoldQuantity3 = stock.StockInfo1.QuantitySold[2];
	m_StockName = stock.StockInfo1.StockName;
	m_SellIdealPrice = stock.StockInfo1.SellExpectedPrice;
	m_BuyIdealPrice = stock.StockInfo1.BuyInExpectedPrice;
	
    UpdateData(FALSE);

	(CButton *)GetDlgItem(IDC_BUTTON_SAVE_PRICE)->EnableWindow(!stock.StockInfo1.Flags.CommentSavedFlag);
	(CButton *)GetDlgItem(IDC_BUTTON_SAVE_NEWS)->EnableWindow(!stock.StockInfo1.Flags.CommentSavedFlag2);
	(CButton *)GetDlgItem(IDC_BUTTON_SAVE_SOLD_HISTROY)->EnableWindow(!stock.StockInfo1.Flags.CommentSavedFlag3);

	
	GetDlgItem(IDC_EDIT_STOCKNAME)->SetFocus();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}




void CStockEditDlg::OnEditOk() 
{
	// TODO: Add your control notification handler code here
	if(!UpdateData( TRUE )) 
		return;	

	OnButtonSavePrice();
	OnButtonSaveNews();
	OnButtonSaveSoldHistory();

	stock.StockInfo1.DateBuyIn = m_StockBuyDate;
	stock.StockInfo1.DateSold[0] = m_StockSoldDate1;
	stock.StockInfo1.DateSold[1] = m_StockSoldDate2;
	stock.StockInfo1.DateSold[2] = m_StockSoldDate3;
	strcpy( stock.StockInfo1.Comments, m_Comments);
	strcpy( stock.StockInfo1.Comments2, m_Comments2);
	strcpy( stock.StockInfo1.Comments3, m_Comments3);
	stock.StockInfo1.BuyInPrice = m_Cost;
	stock.StockInfo1.SoldPrice[0] = m_SellPrice1;
	stock.StockInfo1.SoldPrice[1] = m_SellPrice2;
	stock.StockInfo1.SoldPrice[2] = m_SellPrice3;
	stock.StockInfo1.Quantity = m_BuyInQuantity;
	stock.StockInfo1.QuantitySold[0] = m_SoldQuantity1;
	stock.StockInfo1.QuantitySold[1] = m_SoldQuantity2;
	stock.StockInfo1.QuantitySold[2] = m_SoldQuantity3;
	strcpy( stock.StockInfo1.StockName, m_StockName );
	stock.StockInfo1.SellExpectedPrice = m_SellIdealPrice;
	stock.StockInfo1.BuyInExpectedPrice = m_BuyIdealPrice;
	
	CDialog::OnOK();
}

	extern char **__argv;
void CStockEditDlg::OnButtonSavePrice() 
{
	// TODO: Add your control notification handler code here
	char buf[300];
	if(!UpdateData( TRUE )) 
		return;	

	
	if( strlen(m_Comments) < 2 ||
		strcmp( m_Comments, stock.StockInfo1.Comments) ==0 ) return;
	strcpy( stock.StockInfo1.Comments, m_Comments);

	strcpy(buf, __argv[0]);
	char *p = strrchr(buf, '\\');
	if( p == NULL )
	{
		sprintf(buf, "why no \\ in %s", __argv[0]);
		MessageBox(buf);
		return ;
	}

	sprintf( p+1, "\\lists\\%s_pricetrend.txt", stock.StockInfo1.StockName);	
	FILE *fp = fopen(buf, "a+");
	if( fp == NULL )
	{
		MessageBox("Fail to open file %s", buf);
		return ;
	}

	fprintf(fp, stock.StockInfo1.Comments);
	fprintf(fp, "\r\n");
	fclose(fp);

	stock.StockInfo1.Flags.CommentSavedFlag = 1;
	(CButton *)GetDlgItem(IDC_BUTTON_SAVE_PRICE)->EnableWindow(!stock.StockInfo1.Flags.CommentSavedFlag);
	
}

void CStockEditDlg::OnButtonSaveNews() 
{
	// TODO: Add your control notification handler code here
	char buf[300];
	if(!UpdateData( TRUE )) 
		return;	

	if( strlen(m_Comments2) < 2 ||
		strcmp( m_Comments2, stock.StockInfo1.Comments2) ==0 ) return;
	strcpy( stock.StockInfo1.Comments2, m_Comments2);
	

	strcpy(buf, __argv[0]);
	char *p = strrchr(buf, '\\');
	if( p == NULL )
	{
		sprintf(buf, "why no \\ in %s", __argv[0]);
		MessageBox(buf);
		return ;
	}

	sprintf( p+1, "\\lists\\%s_news.txt", stock.StockInfo1.StockName);	
	FILE *fp = fopen(buf, "a+");
	if( fp == NULL )
	{
		MessageBox("Fail to open file %s", buf);
		return ;
	}

	fprintf(fp, stock.StockInfo1.Comments2);
	fprintf(fp, "\r\n");
	fclose(fp);

	stock.StockInfo1.Flags.CommentSavedFlag2 = 1;
	(CButton *)GetDlgItem(IDC_BUTTON_SAVE_NEWS)->EnableWindow(!stock.StockInfo1.Flags.CommentSavedFlag2);
	
}

void CStockEditDlg::OnButtonSaveSoldHistory() 
{
	// TODO: Add your control notification handler code here
	char buf[300];
	if(!UpdateData( TRUE )) 
		return;	
	if( strlen(m_Comments3) < 2 ||
		strcmp( m_Comments3, stock.StockInfo1.Comments3) ==0 ) return;
	
	strcpy( stock.StockInfo1.Comments3, m_Comments3);
	


	strcpy(buf, __argv[0]);
	char *p = strrchr(buf, '\\');
	if( p == NULL )
	{
		sprintf(buf, "why no \\ in %s", __argv[0]);
		MessageBox(buf);
		return ;
	}

	sprintf( p+1, "\\lists\\%s_sold_histroy.txt", stock.StockInfo1.StockName);	
	FILE *fp = fopen(buf, "a+");
	if( fp == NULL )
	{
		MessageBox("Fail to open file %s", buf);
		return ;
	}

	fprintf(fp, stock.StockInfo1.Comments3);
	fprintf(fp, "\r\n");
	fclose(fp);

	stock.StockInfo1.Flags.CommentSavedFlag3 = 1;
	(CButton *)GetDlgItem(IDC_BUTTON_SAVE_SOLD_HISTROY)->EnableWindow(!stock.StockInfo1.Flags.CommentSavedFlag3);
	
}

void CStockEditDlg::OnChangeEditComments() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	if( stock.StockInfo1.Flags.CommentSavedFlag) 
	{
		stock.StockInfo1.Flags.CommentSavedFlag = 0;
		(CButton *)GetDlgItem(IDC_BUTTON_SAVE_PRICE)->EnableWindow(!stock.StockInfo1.Flags.CommentSavedFlag);
	}
}

void CStockEditDlg::OnChangeEditComments2() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	if( stock.StockInfo1.Flags.CommentSavedFlag2) 
	{
		stock.StockInfo1.Flags.CommentSavedFlag2 = 0;
		(CButton *)GetDlgItem(IDC_BUTTON_SAVE_NEWS)->EnableWindow(!stock.StockInfo1.Flags.CommentSavedFlag2);
	}
}

void CStockEditDlg::OnChangeEditComments3() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	if( stock.StockInfo1.Flags.CommentSavedFlag3) 
	{
		stock.StockInfo1.Flags.CommentSavedFlag3 = 0;
		(CButton *)GetDlgItem(IDC_BUTTON_SAVE_SOLD_HISTROY)->EnableWindow(!stock.StockInfo1.Flags.CommentSavedFlag3);
	}
}
