#include "stdafx.h"
#include "curl_operation.h"
#include <stdio.h>
#include "stdarg.h"


CURL_operations::CURL_operations() {
	// Initialize
	_defaultTimeout = 60;

	_curlGetHandle = NULL;
	_curlPostHandle = NULL;
	_curlUpgradeHandle= NULL;

	init_curlPostHandle();
	init_curlGetHandle();
}

CURL_operations::~CURL_operations() {

	if(_curlGetHandle) {
		curl_easy_cleanup(_curlGetHandle);
		_curlGetHandle = NULL;
	}

	if(_curlPostHandle) {
		curl_easy_cleanup(_curlPostHandle);
		_curlPostHandle = NULL;
	}

	if(_curlUpgradeHandle) {
		curl_easy_cleanup(_curlUpgradeHandle);
		_curlUpgradeHandle = NULL;
	}

}

void CURL_operations::SetTimeout( int TimeoutSeconds)
{
	if( _defaultTimeout != TimeoutSeconds)
		_defaultTimeout = TimeoutSeconds;

}

size_t CURL_operations::curl_write_callback(void *buffer, size_t size, size_t nmemb, void *userp) 
{	
//		size_t		retVal = 0;
		
	std::string	* page = (std::string *) userp;

	size_t	realsize= size * nmemb;
	int orig_len = page->length();		

	// strange enough, '\0' appears in buffer
	int i; 
	char * p = (char *) buffer;
	char * pe = p + realsize;
		
	while(p < pe) {
		i = 0;
		while(p + i < pe && p[i] == '\0') i ++;

		p += i;
		i = 0;
		while(p + i < pe && p[i] != '\0') i ++;

		if (i)  {
			page->append((const char *)p, i);
			p += i;
		}

	}
		
//		page->append((const char *)buffer, realsize);

//		retVal = page->length() - orig_len;

	return realsize;
//		return retVal;



}

int CURL_operations::init_curlGetHandle()
{
	if(_curlGetHandle)
		return 1;

	_curlGetHandle = curl_easy_init();

	if (!_curlGetHandle) 
		return 0;
	else {
		
		//curl_easy_setopt(curlHandle, CURLOPT_VERBOSE, TRUE);

		// Set a default timeout, do not signal
		curl_easy_setopt(_curlGetHandle, CURLOPT_TIMEOUT, _defaultTimeout);
		curl_easy_setopt(_curlGetHandle, CURLOPT_NOSIGNAL, TRUE);

		// We are trying to get a page
		curl_easy_setopt(_curlGetHandle, CURLOPT_HTTPGET, TRUE);

		// Data sink to collect the result of the operation
		curl_easy_setopt(_curlGetHandle, CURLOPT_WRITEFUNCTION, CURL_operations::curl_write_callback);
	} 
	return 1;
}

int CURL_operations::init_curlPostHandle()
{
	if(_curlPostHandle)
		return 1;

	_curlPostHandle = curl_easy_init();

	if (!_curlPostHandle) 
		return 0;
	else {
		
		//curl_easy_setopt(curlHandle, CURLOPT_VERBOSE, TRUE);

		// Set a default timeout, do not signal
		curl_easy_setopt(_curlPostHandle, CURLOPT_TIMEOUT, _defaultTimeout);
		curl_easy_setopt(_curlPostHandle, CURLOPT_NOSIGNAL, TRUE);

		// We are trying to get a page
		curl_easy_setopt(_curlPostHandle, CURLOPT_POST, TRUE);

		// Data sink to collect the result of the operation
		curl_easy_setopt(_curlPostHandle, CURLOPT_WRITEFUNCTION, CURL_operations::curl_write_callback);
	} 
	return 1;
}



int CURL_operations::get_page(const std::string &url, std::string& page)
{
	CURLcode res;

//	page="";				// empty the page
//	page.reserve(64*1024);	// reseve 64k for the page
	
	// haven't got handle yet
	if( !init_curlGetHandle()) 
		return -1;
	
	curl_easy_setopt(_curlGetHandle, CURLOPT_WRITEDATA, &page);
	curl_easy_setopt(_curlGetHandle, CURLOPT_URL, url.c_str());

	res = curl_easy_perform(_curlGetHandle);

	if (res == CURLE_OK)
		return page.length();
	else 
		return -1;
}

#if 0
int CURL_operations::post_form(const std::string &url, const std::string& urlcoded_form, std::string& after_post_page)
{
	CURLcode res;

	//after_post_page = "";				// empty the page
	//after_post_page.reserve(64*1024);	// reseve 64k for the page
	
	// haven't got handle yet
	if( !init_curlPostHandle()) 
		return -1;
	
	curl_easy_setopt(_curlPostHandle, CURLOPT_POSTFIELDS, urlcoded_form.c_str());
	curl_easy_setopt(_curlPostHandle, CURLOPT_URL, url.c_str());
	curl_easy_setopt(_curlPostHandle, CURLOPT_WRITEDATA, &after_post_page);

	res = curl_easy_perform(_curlPostHandle);

	if (res == CURLE_OK)
		return after_post_page.length();
	else 
		return -1;
}

#endif


/*****************************************************************
 *
 *  strstrii (const char *s1, const char *s2);
 *
 *  find the first occurrence of a substring in a string without case sensitivity
 *  
 *  Return: a pointer to the located substring, or NULL if the string is not found
 *
******************************************************************/
char *strstrii(const char *s1, const char *s2)
{
    char *fPtr = (char *) s2;
    char *cPtr = (char *) s1;

	if( ( s1 == NULL ) || ( s2 == NULL ) ) return NULL;
    
    while ( 1 ) 
    {
        if ( *fPtr == 0 )  
        {
            return (char *) s1;
        }

        if ( *cPtr == 0 )  
        {
            return (NULL);
        }

        if ( toupper(*cPtr) == toupper(*fPtr) )  
        {  //prepare for compare next 
            fPtr++;
            cPtr++;
        } 
        else  
        {
            fPtr = (char *) s2;

            s1++; //prepare for new compare
            cPtr = (char *) s1;
        }
    }

}

/*Search value in string (s) according to its startFlag and EndFlag */
char * SearchValue(char *s, char *value, int value_len, char *EndFlag, int StartFlagNum, ...)
{
	va_list arg_ptr;
	char *pFlag;
	char *pTmp;
	char *p;
	char *buffer;
	int valueLen = 0;

	if( s == NULL ) 
	{
		if( value ) 
			value[0] = 0;
		return NULL;
	}

	buffer = (char*) malloc( strlen(s) +1);
	if( buffer == NULL ) 
	{
		if( value ) 
			value[0] = 0;
		return NULL;
	}
	strcpy( buffer, s);

	va_start(arg_ptr, StartFlagNum); //Թ̶ĵַΪȷεڴʼַ

	pTmp = buffer;

    while( StartFlagNum > 0  )
    {     
        pFlag = va_arg(arg_ptr, char * ); //õһɱֵ

		pTmp = strstrii( pTmp, pFlag);
		if( pTmp )
		{
			pTmp += strlen( pFlag);
		}
		else
		{
			free( pTmp);
			return NULL;
		}

		StartFlagNum --;
    } 
	
	va_end(arg_ptr);

	if( EndFlag ) 
	{
		p = strstrii( pTmp, EndFlag);
		if( p == NULL ) 
		{
			free( buffer);
			if( value ) 
				value[0] = 0;
			return NULL;
		}
				
		*p = 0;
		/*remove other elements like <....> */
		{
			char *p1;

			p = pTmp;
			while( (p1 = strstrii( p, "<") ) != NULL )
			{
				p1 = strstrii( p, ">");
				if( p1 == NULL) //not found
					break;

				p1 += 1;
				
				p = p1;					
				pTmp = p1;
			}

		}
	}

	valueLen = strlen(pTmp);
	if( value) 
		strncpy( value, pTmp, value_len);	

	free( buffer);

	return s + (unsigned long) pTmp - (unsigned long)buffer + valueLen;
}



char *FindLastString( char *s, char *flagStr)
{
	char *p1 = NULL;
	char *p2 = NULL;

	p1 = strstrii(s, flagStr);

	while(p1 != NULL )
	{
		p2 = p1;

		p1 += strlen(flagStr);

		p1 = strstrii(p1, flagStr);
	}

	return p2;
}