#ifndef STOCK_H__
#define STOCK_H__



#define URL_MAX_LENGTH  200
#define MAX_STOCK_NUM 200
#define STOCK_PAGES 27  //26 alpha letter + 1 number
#define MY_STOCK_FILENAME "MyStock.dat"
#define MY_STOCK_FILENAME_TMP "MyStock_tmp.dat"
#define MY_STOCK_FILENAME_WARN "MyStock_Warn.dat"

#define url_template_alpha "http://stquote.sgx.com/live/st/STStock.asp?stk=A"
#define url_template_num "http://stquote.sgx.com/live/st/STStock.asp?stk=0-9"

#define MAX_AUTO_STOCK_COUNT 20
#define url_template_volume "http://stquote.sgx.com/live/st/STTop20.asp?top=Vol&cnt=20"
#define url_template_value  "http://stquote.sgx.com/live/st/STTop20.asp?top=Value&cnt=20"
#define url_template_gainer         "http://stquote.sgx.com/live/st/STTop20.asp?top=Gain&cnt=20"
#define url_template_gainer_percent "http://stquote.sgx.com/live/st/STTop20.asp?top=GainP&cnt=20"
#define url_template_loser         "http://stquote.sgx.com/live/st/STTop20.asp?top=Lose&cnt=20"
#define url_template_loser_percent "http://stquote.sgx.com/live/st/STTop20.asp?top=LoseP&cnt=20"


#define GeneralAnnouceFlag1 ">General Announcements"
#define GeneralAnnouceFlag2 "<a href="

#define CoporationInfoFlag1 ">Corporate Information"
#define CoporationInfoFlag2 "<a href="


#define url_template_company_quickinfo "http://info.sgx.com/serviceapp.nsf/Cpy/"

#define SAVE_TYPE_MAIN_STOCK_INFO 1 /*IMPORTANT INFO*/
#define SAVE_TYPE_OTHER_STOCK_INFO  2 /* OTHER INFO*/
#define SAVE_TYPE_WARNING  3 /* OTHER INFO*/

typedef  struct FlagBitStructure
{
	unsigned int CommentSavedFlag:1;   /*0-not saved yet, 1-saved already */
	unsigned int CommentSavedFlag2:1;
	unsigned int CommentSavedFlag3:1;
	unsigned int reserved:29;
}FlagBitStructure;


#define MAX_SOLD_TIMES 3
typedef struct StockElement1 /*save to disk later */
{
	char StockName[32];   //---subindex: 0
	COleDateTime DateBuyIn;
	UINT Quantity;   //---subindex: 13
	float BuyInPrice;  //---subindex: 14
	COleDateTime DateSold[MAX_SOLD_TIMES];
	UINT QuantitySold[MAX_SOLD_TIMES];
	float SoldPrice[MAX_SOLD_TIMES];
	char Comments[100];	 //---subindex: 19  for price prediction by some security agents
	float BuyInExpectedPrice; //---subindex: 17
	float SellExpectedPrice;  //---subindex: 18

	char Comments2[50];  //some company news
	char Comments3[50];  // sold out price history
	FlagBitStructure Flags; 
	
	char Reserved[296];

	
}StockElement1;


typedef struct StockElement2 /* save to another file */
{
	//char Remark[5];
	//float LastPrice;
	//float ChangePrice;
	//float ChangePercent[10];
	//char Volume[10];
	//char VolumeBuy[10];

	//dynamic changing
	float PriceLastDone;  //---subindex: 2
	float PriceSelling;  //---subindex: 8
	float PriceBuying;   //---subindex: 7
	
	//char VolumeSell[10];
	//char HighestPrice[10];
	//char LowestPrice[10];
	//char Sector[10];


	char URL_Quickinfo[URL_MAX_LENGTH]; //in this page, there is corp info, Live Quotes, General Announcements, Past Bonuses and so on

	char URL_GeneralAnnounce[URL_MAX_LENGTH]; //in this page, there is corp info, Live Quotes, General Announcements, Past Bonuses and so on
	char URL_CorporateInformation[URL_MAX_LENGTH];
	char URL_StockChart[URL_MAX_LENGTH];
	char LastAnnounce[URL_MAX_LENGTH]; // --- subindex: 20 

	//char LastGeneralAnnounce[400];

	COleDateTime lastStockTime;
	COleDateTime lastAnnounceInfoTime;
	unsigned char FlagAnnounce; //0--just start the application, no update 1-need update latest annoucement //otherse--no need update to udpate in short time

	char reserved[200];


}StockElement2;


typedef struct Warning_Text 
{
	char Notice[200];

	char reserved[400];

}Warning_Text;


typedef struct StockElement
{
	StockElement1 StockInfo1;  
	StockElement2 StockInfo2;
}StockElement;

typedef struct AlphaListObj
{
	int  Index[MAX_STOCK_NUM];
} AlphaListObj;

class Stock
{

public:
	StockElement StockInfo[MAX_STOCK_NUM];
	int nStocks;
	char URL[URL_MAX_LENGTH];
	Warning_Text Warning;
	int nCurrentAlpha;
	int nNextAlpha;

	AlphaListObj AlphaList[STOCK_PAGES]; //26 alpha letter + 1 number

public:
	Stock();
	virtual	~Stock();
public:	
	void Init();
	char *GetNextUrl(void);
	BOOL AddNewStock(StockElement *pElement);
	void SaveMyStock();
	void SaveMyStock(int type);

	void ReOrderAlphaList();

	void SumUp(float *AllStockCost, float *LastDoneStockSum, float *SellingStockSum);
	

};

BOOL  Cal_P_L(StockElement* pStockElement, char *buf1, char *buf2);

#endif