// MyBtn.cpp : implementation file
//

#include "stdafx.h"
#include "RoundButton.h"

#include "MemDC.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CRoundButton

CRoundButton::CRoundButton()
{
	m_Color = RGB(255,0,255);
}

CRoundButton::~CRoundButton()
{
}


BEGIN_MESSAGE_MAP(CRoundButton, CButton)
	//{{AFX_MSG_MAP(CRoundButton)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRoundButton message handlers

void CRoundButton::SetRound(void)
{
	HRGN rgn;
	CRect wrect;
	GetClientRect(&wrect);
    SetWindowRgn( NULL, FALSE );
	rgn = CreateEllipticRgn( wrect.left, wrect.top,
								wrect.right, wrect.bottom );

	SetWindowRgn(rgn, TRUE);	
}

void CRoundButton::GradientFill (CDC* pDC, CRect* pRect)
{
    CBrush* pBrush[64];
	
	BYTE bRed = (m_Color) & 0xFF;
	BYTE bGreen= (m_Color >> 8 ) & 0xFF;
	BYTE bBlue = (m_Color >> 16 ) & 0xFF;

    for (int i=0; i<64; i++) 
	{
		//pBrush[i] = new CBrush (RGB (0, 0, 255 - (i * 4)));

		pBrush[i] = new CBrush (RGB (bRed, bGreen, bBlue - (i * 4)));
    }

    int nWidth = pRect->Width ();
    int nHeight = pRect->Height ();
    CRect rect;

    for (i=0; i<nHeight; i++) 
	{
        rect.SetRect (0, i, nWidth, i + 1);
        pDC->FillRect (&rect, pBrush[(i * 63) / nHeight]);
    }

    for (i=0; i<64; i++)
        delete pBrush[i];
}

void CRoundButton::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct) 
{
	// TODO: Add your code to draw the specified item
	CRect Rect = lpDrawItemStruct->rcItem;
	CDC *pDC = CDC::FromHandle(lpDrawItemStruct->hDC);
	CRgn rgn;
	CRect rect;

	rect = Rect;

	UINT state = lpDrawItemStruct->itemState;

	CMemDC	*pMemDC = new CMemDC( pDC, Rect);
	CBrush hbr;
	hbr.CreateSolidBrush(GetSysColor(COLOR_BTNFACE));
	//pDC->FillRect( &Rect, &hbr);
	pMemDC->FillRect( &Rect, &hbr);
	hbr.DeleteObject();
	
	if( !(state & ODS_DISABLED) )
	{
		if (state & ODS_SELECTED)
		{
			CPen pen( PS_SOLID, 2, GetSysColor( COLOR_3DHILIGHT ) );
			CPen *pPen;
			CPoint start, end;

			start.x = rect.left;
			start.y = rect.bottom;		
			end.x = rect.right;
			end.y = rect.top;

			rect.left += 2;
			rect.top += 2;
			rect.right -= 2;
			rect.bottom -= 2;

			pPen = pMemDC->SelectObject( &pen );
			pMemDC->Arc( &rect, start, end );
			pMemDC->SelectObject( pPen );
			pen.DeleteObject();
		}
	}

	rgn.CreateEllipticRgn( rect.left, rect.top, 
							rect.right, rect.bottom );
	
	pMemDC->SelectClipRgn( &rgn );	
	GradientFill( pMemDC, &Rect );

	SetRound();

	CClientDC dc(this);

	CString title;
	GetWindowText( title );
	if( title.GetLength() != 0 )
	{
		DrawWhiteText( pMemDC, &Rect, title );
		title.ReleaseBuffer();
	}

	delete pMemDC;
}

void CRoundButton::DrawWhiteText(CDC* pDC, CRect* pRect, CString& text )
{
    CFont font;
    int nHeight = -16;

    font.CreateFont (nHeight, 0, 0, 0, FW_BOLD,
        TRUE, 0, 0, DEFAULT_CHARSET, OUT_CHARACTER_PRECIS,
        CLIP_CHARACTER_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH |
        FF_DONTCARE, "Times New Roman");

    pDC->SetBkMode(TRANSPARENT);
    pDC->SetTextColor(RGB (255, 255, 255));

    CFont* pOldFont = pDC->SelectObject (&font);
    pDC->DrawText (text, -1, pRect, DT_SINGLELINE | DT_CENTER |
					    DT_VCENTER);

    pDC->SelectObject (pOldFont);
}

void CRoundButton::SetColor( COLORREF Color)
{
	m_Color = Color;
}