#include "stdafx.h"
#include "Iphlpapi.h" /*I don't know why vc also have the header file, 
                        and sdk have aslo it. So I delete vc's file,
						otherwise, complile error */

#include "Iprtrmib.h"
#include "Winsock2.h"
#include "WS2TCPIP.H"
#include "network_sgh.h"
#include "uconfigmain.h"

PIP_ADAPTER_INFO    pNetAdapterInfo = NULL;
PFIXED_INFO         pFixedInfo = NULL;
//PMIB_IPFORWARDTABLE pIpRouteTab = NULL; // Ip routing table

extern CListCtrl	*NPFindListCtrl ;
extern CListCtrl	*ForwardListCtrl;
extern CListCtrl	*NetInterfaceListCtrl;

BOOL PhysAddrToString(BYTE PhysAddr[], DWORD PhysAddrLen, char str[]);
/**************************************************
   Get net work Parameters
**************************************************/
/**************************************************
   Get every net adaptor's information
**************************************************/
BOOL  GetNetAdaptorInfo(CListCtrl	*pNetInterfaceListCtrl)
{
	// Enumerate all of the adapter specific information using the IP_ADAPTER_INFO structure.
    // Note:  IP_ADAPTER_INFO contains a linked list of adapter entries.
    //
	DWORD Err;
	CString s;
	char buf[255];
    DWORD FixedInfoSize = 0;
    DWORD AdapterInfoSize;
	PIP_ADAPTER_INFO pAdapt;
	PIP_ADDR_STRING pAddrStr;
	LV_ITEM lv_item;
	
    AdapterInfoSize = 0;
	NetInterfaceListCtrl = pNetInterfaceListCtrl;
	
    if ((Err = GetAdaptersInfo(NULL, &AdapterInfoSize)) != 0)
    {
        if (Err != ERROR_BUFFER_OVERFLOW)
        {
            s.Format("GetAdaptersInfo sizing failed with error %d\n", Err);
			AfxMessageBox(s);
            return FALSE;
        }
    }

    // Allocate memory from sizing information
	if( pNetAdapterInfo != NULL )
	{
		free( pNetAdapterInfo );
		pNetAdapterInfo = NULL;

	}
    if ((pNetAdapterInfo = (PIP_ADAPTER_INFO) malloc( AdapterInfoSize)) == NULL)
    {
        s.Format("Memory allocation error\n");
		AfxMessageBox(s);
        return FALSE;
    }

    // Get actual adapter information
    if ((Err = GetAdaptersInfo(pNetAdapterInfo, &AdapterInfoSize)) != 0)
    {
        s.Format("GetAdaptersInfo failed with error %d\n", Err);
		AfxMessageBox(s);
        return FALSE;
    }

    pAdapt = pNetAdapterInfo;

	lv_item.mask = LVIF_TEXT;
	lv_item.cchTextMax = 255;
    while (pAdapt)
    {
        switch (pAdapt->Type)
        {
            case MIB_IF_TYPE_ETHERNET:
                //s.Format("\nEthernet adapter ");
                break;
            case MIB_IF_TYPE_TOKENRING:
                //s.Format("\nToken Ring adapter ");
                break;
            case MIB_IF_TYPE_FDDI:
                //s.Format("\nFDDI adapter ");
                break;
            case MIB_IF_TYPE_PPP:
                s.Format("\nPPP adapter ");
                break;
            case MIB_IF_TYPE_LOOPBACK:
                //s.Format("\nLoopback adapter ");
                break;
            case MIB_IF_TYPE_SLIP:
                //s.Format("\nSlip adapter ");
                break;
            case MIB_IF_TYPE_OTHER:
            default:
                //s.Format("\nOther adapter ");
				break;
        }
        
		if( pAdapt->Type != MIB_IF_TYPE_ETHERNET ||
			strstr(pAdapt->Description, "PPP") != NULL ||
			strstr(pAdapt->Description, "ppp") != NULL )

		{  //only show enthernet adaptor
			pAdapt = pAdapt->Next;
			continue;
		}
		
		//Description				
		lv_item.iItem = pNetInterfaceListCtrl->GetItemCount();
		lv_item.iSubItem = 0;		
		lv_item.pszText = pAdapt->Description;
		pNetInterfaceListCtrl->InsertItem( &lv_item );


        //Mac
		s = "";
		buf[0] = 0;
        for (UINT i=0; i<pAdapt->AddressLength; i++)
        {
            if (i == (pAdapt->AddressLength - 1))
                s.Format("%.2X",(int)pAdapt->Address[i]);
            else
                s.Format("%.2X-",(int)pAdapt->Address[i]);
			strcat(buf, s);
        }
		memcpy( AdaptorInfoArray[lv_item.iItem].Mac, pAdapt->Address, 6);
		
		lv_item.iSubItem = 1;
		lv_item.pszText = buf;
		pNetInterfaceListCtrl->SetItem( &lv_item );
		
		
		//s.Format("\tDHCP Enabled. . . . . . . . : %s\n", (pAdapt->DhcpEnabled ? "yes" : "no"));

        pAddrStr = &(pAdapt->IpAddressList);
        while(pAddrStr)
        {	
			//IP			
			lv_item.iSubItem = 2;		
			lv_item.pszText = pAddrStr->IpAddress.String;
			pNetInterfaceListCtrl->SetItem( &lv_item );
			strcpy( AdaptorInfoArray[lv_item.iItem].IP, pAddrStr->IpAddress.String);
				
			
			//Mask
			lv_item.iSubItem = 3;		
			lv_item.pszText = pAddrStr->IpMask.String;
			pNetInterfaceListCtrl->SetItem( &lv_item );
			strcpy( AdaptorInfoArray[lv_item.iItem].Mask, pAddrStr->IpMask.String );
		            
			break; //only show first ip/mask for every net card
			pAddrStr = pAddrStr->Next;	//no use now
			
        }

        //gateway
		s = pAdapt->GatewayList.IpAddress.String;
        pAddrStr = pAdapt->GatewayList.Next;
        while(pAddrStr)
        {
            s += pAddrStr->IpAddress.String;
			s += " ";
            
			pAddrStr = pAddrStr->Next;
        }

		strcpy(buf, s);
		lv_item.iSubItem = 4;		
		lv_item.pszText = buf;
		pNetInterfaceListCtrl->SetItem( &lv_item );

        /*
		s.Format("\tDHCP Server . . . . . . . . : %s\n", pAdapt->DhcpServer.IpAddress.String);
        s.Format("\tPrimary WINS Server . . . . : %s\n", pAdapt->PrimaryWinsServer.IpAddress.String);
        s.Format("\tSecondary WINS Server . . . : %s\n", pAdapt->SecondaryWinsServer.IpAddress.String);

        struct tm *newtime;

        // Display coordinated universal time - GMT 
        newtime = gmtime(&pAdapt->LeaseObtained);   
        s.Format( "\tLease Obtained. . . . . . . : %s", asctime( newtime ) );

        newtime = gmtime(&pAdapt->LeaseExpires);   
        s.Format( "\tLease Expires . . . . . . . : %s", asctime( newtime ) );		
		*/
	
		AdaptorInfoArray[lv_item.iItem].dwIndex = pAdapt->Index;
		
		
        pAdapt = pAdapt->Next;
    }
	
	//m_NetInterfaceList.InsertString(m_NetInterfaceList.GetCount(), "2");	
	return TRUE;
}


BOOL GetNetAdaptorInfoViaMac(char *Mac, char *IP, char *Subnet)
{
	// Enumerate all of the adapter specific information using the IP_ADAPTER_INFO structure.
    // Note:  IP_ADAPTER_INFO contains a linked list of adapter entries.
    //
	DWORD Err;
	CString s;
    DWORD FixedInfoSize = 0;
    DWORD AdapterInfoSize;
	PIP_ADAPTER_INFO pAdapt;
	PIP_ADDR_STRING pAddrStr;
		
    AdapterInfoSize = 0;	
	
    if ((Err = GetAdaptersInfo(NULL, &AdapterInfoSize)) != 0)
    {
        if (Err != ERROR_BUFFER_OVERFLOW)
        {
            //s.Format("GetAdaptersInfo sizing failed with error %d\n", Err);
			//AfxMessageBox(s);
            return FALSE;
        }
    }

    // Allocate memory from sizing information
	if( pNetAdapterInfo != NULL )
	{
		free( pNetAdapterInfo );
		pNetAdapterInfo = NULL;

	}
    if ((pNetAdapterInfo = (PIP_ADAPTER_INFO) malloc( AdapterInfoSize)) == NULL)
    {
        //s.Format("Memory allocation error\n");
		//AfxMessageBox(s);
        return FALSE;
    }

    // Get actual adapter information
    if ((Err = GetAdaptersInfo(pNetAdapterInfo, &AdapterInfoSize)) != 0)
    {
        //s.Format("GetAdaptersInfo failed with error %d\n", Err);
		//AfxMessageBox(s);
        return FALSE;
    }

    pAdapt = pNetAdapterInfo;

    while (pAdapt)
    {
        switch (pAdapt->Type)
        {
            case MIB_IF_TYPE_ETHERNET:
                //s.Format("\nEthernet adapter ");
                break;
            case MIB_IF_TYPE_TOKENRING:
                //s.Format("\nToken Ring adapter ");
                break;
            case MIB_IF_TYPE_FDDI:
                //s.Format("\nFDDI adapter ");
                break;
            case MIB_IF_TYPE_PPP:
                s.Format("\nPPP adapter ");
                break;
            case MIB_IF_TYPE_LOOPBACK:
                //s.Format("\nLoopback adapter ");
                break;
            case MIB_IF_TYPE_SLIP:
                //s.Format("\nSlip adapter ");
                break;
            case MIB_IF_TYPE_OTHER:
            default:
                //s.Format("\nOther adapter ");
				break;
        }
        
		if( pAdapt->Type != MIB_IF_TYPE_ETHERNET ||
			strstr(pAdapt->Description, "PPP") != NULL ||
			strstr(pAdapt->Description, "ppp") != NULL )

		{  //only show enthernet adaptor
			pAdapt = pAdapt->Next;
			continue;
		}
		

		if( memcmp(Mac, pAdapt->Address, 6) == 0 )
		{ //find ok
			pAddrStr = &(pAdapt->IpAddressList);
						
			if( inet_addr(pAddrStr->IpAddress.String) == 0) 
			{  //0.0.0.0
				return FALSE;
			}
			else 
			{
				strcpy( IP, pAddrStr->IpAddress.String );
				strcpy( Subnet, pAddrStr->IpMask.String );
				return TRUE;
			}
			
		}

		pAdapt = pAdapt->Next;
	}		
		
	return FALSE;
}


BOOL GetNetworkInfo(CStatic *pMainIPConfig_StaticCtrl)
{
	DWORD Err;
	CString s, s1;
    DWORD FixedInfoSize = 0;    
	PIP_ADDR_STRING pAddrStr;

    // Get the main IP configuration information for this machine using a FIXED_INFO structure  
    if ((Err = GetNetworkParams(NULL, &FixedInfoSize)) != 0)
    {
        if (Err != ERROR_BUFFER_OVERFLOW)
        {
            s.Format("GetNetworkParams sizing failed with error %d", Err);
			AfxMessageBox(s);
            return FALSE;
        }
    }

    // Allocate memory from sizing information
	if( pFixedInfo != NULL )
	{
		free( pFixedInfo );
		pFixedInfo = NULL;
	}

    if ((pFixedInfo = (PFIXED_INFO) malloc(FixedInfoSize)) == NULL)
    {
        s.Format("Memory allocation error");
		AfxMessageBox(s);	
        return FALSE;
    }

	s = "";
    if ((Err = GetNetworkParams(pFixedInfo, &FixedInfoSize)) == 0)
    {
		s += "Host Name:"; 
		s += pFixedInfo->HostName;

		s += "\r\nDomainName:";
		s += pFixedInfo->DomainName;
        
		s += "\r\nDNS Servers:";
		s += pFixedInfo->DnsServerList.IpAddress.String;
		pAddrStr = pFixedInfo->DnsServerList.Next;
        while(pAddrStr)
        {
			s += "\r\n                     ";
            s += pAddrStr->IpAddress.String;
            pAddrStr = pAddrStr->Next;
        }

		s += "\r\nNode Type:";
        switch (pFixedInfo->NodeType)
        {
            case 1:
                s += "Broadcast";
                break;
            case 2:
                s += "Peer to peer";
                break;
            case 4:
                s += "Mixed";
                break;
            case 8:
                s += "Hybrid";
                break;
            default:
                s1.Format("%d", pFixedInfo->NodeType);
				s += s1;
        }

		s += "\r\nNetBIOS Scope ID:";
		s1.Format("%s", pFixedInfo->ScopeId);
		s += s1;

		s += "\r\nIP Routing Enabled:";
		s1.Format("%s", (pFixedInfo->EnableRouting ? "yes" : "no"));
		s += s1;

		s += "\r\nWINS Proxy Enabled:";
		s1.Format("%s", (pFixedInfo->EnableProxy ? "yes" : "no"));
		s += s1;
		
		s += "\r\nNetBIOS Resolution Uses DNS:";
        s1.Format("%s", (pFixedInfo->EnableDns ? "yes" : "no"));
		s + s1;
    }
	else
    {
        s.Format("GetNetworkParams failed with error %d\n", Err);
		AfxMessageBox(s);
        return FALSE;
    }


	pMainIPConfig_StaticCtrl->SetWindowText(s);
	
	return TRUE;
}


/**********************************************
        Get current Route/Forward table 
********************************************/
BOOL DoGetIpForwardTable(CListCtrl	*pForwardListCtrl,  BOOL bfUpdateVariant)
{
    DWORD dwStatus;
    PMIB_IPFORWARDTABLE pIpRouteTab = NULL; // Ip routing table

	ForwardListCtrl = pForwardListCtrl;	
    
    if ( (dwStatus = MyGetIpForwardTable(pIpRouteTab, TRUE)) == NO_ERROR)
    {
        PrintIpForwardTable(pIpRouteTab, pForwardListCtrl, bfUpdateVariant );
        
		return TRUE;
    }
    else if ( dwStatus == ERROR_NO_DATA)
    {
        AfxMessageBox("No entries exist in route table.\n");
        if (pIpRouteTab)
		{
            free(pIpRouteTab);
			pIpRouteTab = NULL;
		}
        return FALSE;
    }

    free (pIpRouteTab);
	pIpRouteTab = NULL;
	return TRUE;
}

/***********************************************************************************
DoSetIpForwardEntry: add new Route item into table
INPUT param: pszDest ---- Network Destination
            pszNetMask-- Netmask
            pszGateway--Gateway
            pszInterface--Interface
            dwMetric  --Metric

Example for a route table:
Network Destination        Netmask          Gateway       Interface  Metric
          0.0.0.0          0.0.0.0     192.168.88.2   192.168.88.38       1
        127.0.0.0        255.0.0.0        127.0.0.1       127.0.0.1       1
     192.168.88.0    255.255.255.0    192.168.88.38   192.168.88.38       1
    192.168.88.38  255.255.255.255        127.0.0.1       127.0.0.1       1
   192.168.88.255  255.255.255.255    192.168.88.38   192.168.88.38       1
    192.168.168.0    255.255.255.0   192.168.168.88  192.168.168.88       1
   192.168.168.88  255.255.255.255        127.0.0.1       127.0.0.1       1
 
 ***********************************************************************************/
BOOL DoSetIpForwardEntry(char* pszDest, char* pszNetMask, char* pszGateway, char* pszInterface, DWORD dwMetric)
{
    DWORD dwStatus;

    MIB_IPFORWARDROW routeEntry;            // Ip routing table row entry
    PMIB_IPADDRTABLE pIpAddrTable = NULL;   // Ip Addr Table
    DWORD dwIfIndex;                        // Interface index number  
    DWORD dwIfMask;                         // Interface Subnet Mask
    DWORD dwIfIpAddr;                       // Interface Ip Address
    
    memset(&routeEntry, 0, sizeof(MIB_IPFORWARDROW));
    

    // converting and checking input arguments...
    if (pszDest == NULL || pszNetMask == NULL || pszGateway == NULL)
    {
        //AfxMessageBox("IpRoute: Bad Argument");
        return FALSE;
    }

    routeEntry.dwForwardDest = inet_addr(pszDest); // convert dotted ip addr. to ip addr.
    if (routeEntry.dwForwardDest == INADDR_NONE)
    {
		CString s;
		s.Format("IpRoute: Bad Destination %s", pszDest);
        AfxMessageBox(s);
        return FALSE;
    }

    routeEntry.dwForwardMask = inet_addr(pszNetMask);
    if ( (routeEntry.dwForwardMask == INADDR_NONE) && 
         (strcmp("255.255.255.255", pszNetMask) != 0) )
    {

		CString s;
		s.Format("IpRoute: Bad Mask %s\n", pszNetMask);
        AfxMessageBox(s);
        return FALSE;
    }

    routeEntry.dwForwardNextHop = inet_addr(pszGateway);
    if (routeEntry.dwForwardNextHop == INADDR_NONE)
    {
        CString s;
		s.Format("IpRoute: Bad Gateway %s\n", pszGateway);
        AfxMessageBox(s);
        return FALSE;
    }

    if ( (routeEntry.dwForwardDest & routeEntry.dwForwardMask) != routeEntry.dwForwardDest)
    {
        CString s;
		s.Format("IpRoute: Invalid Mask %s\n", pszNetMask);
        AfxMessageBox(s);
        return FALSE;
    }

    dwIfIpAddr = inet_addr(pszInterface);
    if (dwIfIpAddr == INADDR_NONE)
    {
        
		CString s;
		s.Format("IpRoute: Bad Interface %s\n", pszInterface);
        AfxMessageBox(s);
        
        return FALSE;
    }

    // Check if we have the given interface
    if ( (dwStatus = MyGetIpAddrTable(pIpAddrTable)) != NO_ERROR)
    {
		CString s;
		s.Format("GetIpAddrTable returned 0x%x\n", dwStatus);
        AfxMessageBox(s);
        if (pIpAddrTable)
		{
            free(pIpAddrTable);
			pIpAddrTable = NULL;
		}
        return FALSE;
    }

    ASSERT(pIpAddrTable != NULL);
    if ( InterfaceIpToIdxAndMask(pIpAddrTable, pszInterface, dwIfIndex, dwIfMask) == FALSE)
    {        
		CString s;
		s.Format("IpRoute: Bad Argument %s\n", pszInterface);
        //AfxMessageBox(s);
        return FALSE;
    }
    free(pIpAddrTable);
	pIpAddrTable = NULL;

    if ( (routeEntry.dwForwardNextHop & dwIfMask) != (dwIfIpAddr & dwIfMask) )
    {
        
		CString s;
		s.Format("IpRoute: Gateway %s and Interface %s are not in the same subnet.\n", pszGateway, pszInterface);
        AfxMessageBox(s);
        return FALSE;
    }

    routeEntry.dwForwardIfIndex = dwIfIndex;

    routeEntry.dwForwardMetric1 = dwMetric;
	routeEntry.dwForwardType  = 3 ;// 4;
	routeEntry.dwForwardAge  = (DWORD)-1;
	routeEntry.dwForwardPolicy = 0;

	//I don't know although it is defined in Iprtrmib.h, but compiler cannot
	//find it. So I here define it
	#define MIB_IPPROTO_NT_STATIC           10006
    
	
	// some default values
    routeEntry.dwForwardProto = MIB_IPPROTO_NT_STATIC;//MIB_IPPROTO_LOCAL;//MIB_IPPROTO_NT_AUTOSTATIC
    routeEntry.dwForwardMetric2 = (DWORD)-1;
    routeEntry.dwForwardMetric3 = (DWORD)-1;
    routeEntry.dwForwardMetric4 = (DWORD)-1;
	routeEntry.dwForwardMetric5 = (DWORD)-1;
    
    dwStatus = SetIpForwardEntry(&routeEntry); 
 
	if (dwStatus != NO_ERROR)
    {
        char *lpMsgBuf;
		FormatMessage( 
			FORMAT_MESSAGE_ALLOCATE_BUFFER | 
			FORMAT_MESSAGE_FROM_SYSTEM | 
			FORMAT_MESSAGE_IGNORE_INSERTS,
			NULL,
			//GetLastError(),
			dwStatus,

			MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
						(LPTSTR) &lpMsgBuf,
			0,    NULL );

		CString s;
		s.Format("dwForwardDest     : %s\n \
			      dwForwardMask     : %s\n \
				  dwForwardPolicy   : %d\n \
				  dwForwardNextHop  : %s\n \
				  dwForwardIfIndex  : %d\n \
				  dwForwardType     : %d\n \
				  dwForwardProto    : %d\n \
				  dwForwardAge      : %d\n \
				  dwForwardNextHopAS: %d\n \
				  dwForwardMetric1: %d\n ",
				  
				  inet_ntoa( *(struct in_addr *)&routeEntry.dwForwardDest),
				  inet_ntoa( *(struct in_addr *)&routeEntry.dwForwardMask),
				  routeEntry.dwForwardPolicy, 
				  inet_ntoa( *(struct in_addr *)&routeEntry.dwForwardNextHop),				  
				  routeEntry.dwForwardIfIndex, 
				  routeEntry.dwForwardType,
				  routeEntry.dwForwardProto, 
				  routeEntry.dwForwardAge, 
				  routeEntry.dwForwardAge,  
				  routeEntry.dwForwardNextHopAS  );

		s += "Error :";
		s += lpMsgBuf;
		
		AfxMessageBox(lpMsgBuf);
		LocalFree( lpMsgBuf );
		lpMsgBuf = NULL;

		//next: 
		routeEntry.dwForwardProto = MIB_IPPROTO_LOCAL;//MIB_IPPROTO_NT_AUTOSTATIC

		dwStatus = SetIpForwardEntry(&routeEntry); 
 
		if (dwStatus != NO_ERROR)
		{
			char *lpMsgBuf;
			FormatMessage( 
				FORMAT_MESSAGE_ALLOCATE_BUFFER | 
				FORMAT_MESSAGE_FROM_SYSTEM | 
				FORMAT_MESSAGE_IGNORE_INSERTS,
				NULL,
				//GetLastError(),
				dwStatus,

				MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
							(LPTSTR) &lpMsgBuf,
				0,    NULL );

			CString s;
			s.Format("dwForwardDest     : %s\n \
					  dwForwardMask     : %s\n \
					  dwForwardPolicy   : %d\n \
					  dwForwardNextHop  : %s\n \
					  dwForwardIfIndex  : %d\n \
					  dwForwardType     : %d\n \
					  dwForwardProto    : %d\n \
					  dwForwardAge      : %d\n \
					  dwForwardNextHopAS: %d\n \
					  dwForwardMetric1: %d\n ",
					  
					  inet_ntoa( *(struct in_addr *)&routeEntry.dwForwardDest),
					  inet_ntoa( *(struct in_addr *)&routeEntry.dwForwardMask),
					  routeEntry.dwForwardPolicy, 
					  inet_ntoa( *(struct in_addr *)&routeEntry.dwForwardNextHop),				  
					  routeEntry.dwForwardIfIndex, 
					  routeEntry.dwForwardType,
					  routeEntry.dwForwardProto, 
					  routeEntry.dwForwardAge, 
					  routeEntry.dwForwardAge,  
					  routeEntry.dwForwardNextHopAS  );

			s += "Error :";
			s += lpMsgBuf;
			
			AfxMessageBox(lpMsgBuf);
			LocalFree( lpMsgBuf );
			lpMsgBuf = NULL;
		}
		else return TRUE;

			//next: 
			routeEntry.dwForwardProto = MIB_IPPROTO_LOCAL;//MIB_IPPROTO_NT_AUTOSTATIC

			dwStatus = SetIpForwardEntry(&routeEntry); 
 
			if (dwStatus != NO_ERROR)
			{
				char *lpMsgBuf;
				FormatMessage( 
					FORMAT_MESSAGE_ALLOCATE_BUFFER | 
					FORMAT_MESSAGE_FROM_SYSTEM | 
					FORMAT_MESSAGE_IGNORE_INSERTS,
					NULL,
					//GetLastError(),
					dwStatus,

					MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
								(LPTSTR) &lpMsgBuf,
					0,    NULL );

				CString s;
				s.Format("dwForwardDest     : %s\n \
						  dwForwardMask     : %s\n \
						  dwForwardPolicy   : %d\n \
						  dwForwardNextHop  : %s\n \
						  dwForwardIfIndex  : %d\n \
						  dwForwardType     : %d\n \
						  dwForwardProto    : %d\n \
						  dwForwardAge      : %d\n \
						  dwForwardNextHopAS: %d\n \
						  dwForwardMetric1: %d\n ",
						  
						  inet_ntoa( *(struct in_addr *)&routeEntry.dwForwardDest),
						  inet_ntoa( *(struct in_addr *)&routeEntry.dwForwardMask),
						  routeEntry.dwForwardPolicy, 
						  inet_ntoa( *(struct in_addr *)&routeEntry.dwForwardNextHop),				  
						  routeEntry.dwForwardIfIndex, 
						  routeEntry.dwForwardType,
						  routeEntry.dwForwardProto, 
						  routeEntry.dwForwardAge, 
						  routeEntry.dwForwardAge,  
						  routeEntry.dwForwardNextHopAS  );

				s += "Error :";
				s += lpMsgBuf;
				
				AfxMessageBox(lpMsgBuf);
				LocalFree( lpMsgBuf );
				lpMsgBuf = NULL;
			}
			else return TRUE;

		return FALSE;

    }
	
	return TRUE;
}

/**************************************************
 delete Route Network Destination in route  table.
INPUT param: pszDest ---- the Network Destination
 Network Destination        Netmask          Gateway       Interface  Metric
          0.0.0.0          0.0.0.0     192.168.88.2   192.168.88.38       1
        127.0.0.0        255.0.0.0        127.0.0.1       127.0.0.1       1
     192.168.88.0    255.255.255.0    192.168.88.38   192.168.88.38       1
    192.168.88.38  255.255.255.255        127.0.0.1       127.0.0.1       1
   192.168.88.255  255.255.255.255    192.168.88.38   192.168.88.38       1
    192.168.168.0    255.255.255.0   192.168.168.88  192.168.168.88       1
   192.168.168.88  255.255.255.255        127.0.0.1       127.0.0.1       1
 
 **************************************************/
void DoDeleteIpForwardEntry(char* pszDest)
{
    DWORD dwStatus, dwDelStatus, i;
    PMIB_IPFORWARDTABLE pIpRouteTab = NULL; // Ip routing table
    MIB_IPFORWARDROW routeEntry;            // Ip routing table row entry
    DWORD dwForwardDest = 0;
    BOOL fDeleted = FALSE;

    memset(&routeEntry, 0, sizeof(MIB_IPFORWARDROW));
    dwForwardDest = inet_addr(pszDest); // convert dotted ip addr. to ip addr.
    if (dwForwardDest == INADDR_NONE)
    {
        ////printf("IpRoute: Bad Destination %s\n", pszDest);
        return;
    }

    if ( (dwStatus = MyGetIpForwardTable(pIpRouteTab, TRUE)) == NO_ERROR)
    {
        for (i = 0; i < pIpRouteTab->dwNumEntries; i++)
        {
            if (dwForwardDest == pIpRouteTab->table[i].dwForwardDest)
            {
                memcpy(&routeEntry, &(pIpRouteTab->table[i]), sizeof(MIB_IPFORWARDROW));
                dwDelStatus = DeleteIpForwardEntry(&routeEntry); 
                if (dwDelStatus != NO_ERROR)
                {
                    ////printf("IpRoute: couldn't delete (%s), dwStatus = %lu.\n",
                    //        pszDest, dwDelStatus);
                    return;
                }
                else
                    fDeleted = TRUE;
            }
        }
        free(pIpRouteTab);
		pIpRouteTab = NULL;

        if (! fDeleted)
            ////printf("IpRoute: The route specified was not found.\n");
        return;
    }
    else if ( dwStatus == ERROR_NO_DATA)
    {
        ////printf("IpRoute: No entries in route table.\n");
        if (pIpRouteTab)
		{
            free (pIpRouteTab);
			pIpRouteTab = NULL;
		}
        return;
    }
    else
    {
        if (pIpRouteTab)
		{
            free (pIpRouteTab);
			pIpRouteTab = NULL;
		}
        //printf("IpRoute returned 0x%x\n", dwStatus);
        return;
    }

}


//----------------------------------------------------------------------------
// If returned status is NO_ERROR, then pIpRouteTab points to a routing
// table.
//----------------------------------------------------------------------------
DWORD MyGetIpForwardTable(PMIB_IPFORWARDTABLE& pIpRouteTab, BOOL fOrder)
{
    DWORD status = NO_ERROR;
    DWORD statusRetry = NO_ERROR;
    DWORD dwActualSize = 0;
    
    // query for buffer size needed
    status = GetIpForwardTable(pIpRouteTab, &dwActualSize, fOrder);

    if (status == NO_ERROR)
    {
        //printf("No error\n");
        return status;
    }
    else if (status == ERROR_INSUFFICIENT_BUFFER)
    {
        // need more space
		if( pIpRouteTab != NULL )
		{
			free( pIpRouteTab );
			pIpRouteTab = NULL;
		}
        pIpRouteTab = (PMIB_IPFORWARDTABLE) malloc(dwActualSize);
        ASSERT(pIpRouteTab!=NULL);
        
        statusRetry = GetIpForwardTable(pIpRouteTab, &dwActualSize, fOrder);
        return statusRetry;
    }
    else
    {
        return status;
    }

}

//----------------------------------------------------------------------------
// Print out ip routing table in the following format:
//Active Routes:
//
//  Network Address          Netmask  Gateway Address        Interface  Metric
//          0.0.0.0          0.0.0.0     157.54.176.1   157.54.177.149       1
//        127.0.0.0        255.0.0.0        127.0.0.1        127.0.0.1       1
//     157.54.176.0    255.255.252.0   157.54.177.149   157.54.177.149       1
//   157.54.177.149  255.255.255.255        127.0.0.1        127.0.0.1       1
//   157.54.255.255  255.255.255.255   157.54.177.149   157.54.177.149       1
//        224.0.0.0        224.0.0.0   157.54.177.149   157.54.177.149       1
//  255.255.255.255  255.255.255.255   157.54.177.149   157.54.177.149       1
//----------------------------------------------------------------------------
//pForwardListCtrl--- The list control for print the route table
//bfUpdateVariant--- if TRUE, then update some global variant for uConfig
//			   --- if FALSE, then not update those gobal variant, ie, at most print route table
void PrintIpForwardTable(PMIB_IPFORWARDTABLE pIpRouteTable, CListCtrl *pForwardListCtrl, BOOL bfUpdateVariant)
{
    DWORD i, dwStatus, dwCurrIndex;
    struct in_addr inadDest;
    struct in_addr inadMask;
    struct in_addr inadGateway;  
    char szIpAddr[128];          // ip address of an interface index
    PMIB_IPADDRTABLE pIpAddrTable = NULL;
	LV_ITEM lv_item;

    char szDestIp[128 + 2];
    char szMaskIp[128];
    char szGatewayIp[128];
	char szMerit[10];
	
	lv_item.mask = LVIF_TEXT;
	lv_item.cchTextMax = 255;

    if (pIpRouteTable == NULL)
    {
        AfxMessageBox( "pIpRouteTable == NULL in line %d\n", __LINE__);
        return;
    }
    // get IP Address Table for mapping interface index number to ip address
    if ( (dwStatus = MyGetIpAddrTable(pIpAddrTable)) != NO_ERROR)
    {
		CString s;
		s.Format("GetIpAddrTable returned 0x%x\n", dwStatus);
		AfxMessageBox(s);
        if (pIpAddrTable)
		{
            free(pIpAddrTable);
			pIpAddrTable = NULL;
		}
        return;
    }
    ASSERT(pIpAddrTable!=NULL);

    //pForwardListCtrl->EnableWindow(TRUE);

	pForwardListCtrl->DeleteAllItems();
    	
	for (i = 0; i < pIpRouteTable->dwNumEntries; i++)
    {
        dwCurrIndex = pIpRouteTable->table[i].dwForwardIfIndex;
		CString ss;
		
        if (InterfaceIdxToInterfaceIp(pIpAddrTable, dwCurrIndex, szIpAddr) == FALSE)
        {
            AfxMessageBox("Error: Could not convert Interface number 0x%X to IP address.\n",dwCurrIndex);

            if (pIpAddrTable)
			{
                free(pIpAddrTable);
				pIpAddrTable = NULL;
			}
            //pForwardListCtrl->EnableWindow(FALSE);
            return;
        }
        
        inadDest.s_addr = pIpRouteTable->table[i].dwForwardDest;
        inadMask.s_addr = pIpRouteTable->table[i].dwForwardMask;
        inadGateway.s_addr = pIpRouteTable->table[i].dwForwardNextHop;

		if( bfUpdateVariant )
		{   //need update some global variant for uConfig
			if( strcmp( inet_ntoa(inadDest), NPListArray[nSelectedNPIndex].IP ) == 0 )
			{ //find the default gateway
				if( strcmp( szIpAddr, AdaptorInfoArray[CURRENT_ADAPTOR_INDEX].IP) == 0) 
				{
					strcpy( DefaultHostRouteDest, inet_ntoa(inadDest) ); 
					strcpy( DefaultHostRouteMask, inet_ntoa(inadMask) );
					strcpy( DefaultHostRouteIP, inet_ntoa( inadGateway) );
					strcpy( DefaultHostRouteInterface, szIpAddr);			
				}	
			}
		}
	
        
		//add No into szDestIp
	#if 0
		sprintf(szDestIp, "%02d  ", pForwardListCtrl->GetItemCount() );
	#else
		szDestIp[0] = 0; 
	#endif 
        strcat(szDestIp, inet_ntoa(inadDest));

        strcpy(szMaskIp, inet_ntoa(inadMask));
        strcpy(szGatewayIp, inet_ntoa(inadGateway));
		
		//Network Destination
		lv_item.iItem = pForwardListCtrl->GetItemCount();
		lv_item.iSubItem = 0;
		lv_item.pszText = szDestIp;
		pForwardListCtrl->InsertItem( &lv_item );

		//NetMask
		//lv_item.iItem = pForwardListCtrl->GetItemCount() -1;
		lv_item.iSubItem = 1;
		lv_item.pszText = szMaskIp;
		pForwardListCtrl->SetItem( &lv_item );

		//lv_item.iItem = pForwardListCtrl->GetItemCount()-1;
		lv_item.iSubItem = 2;
		lv_item.pszText = szGatewayIp;
		pForwardListCtrl->SetItem( &lv_item );
		
		//interface
		sprintf(szMerit, "%d", pIpRouteTable->table[i].dwForwardMetric1);
		lv_item.iSubItem = 3;
		lv_item.pszText = szIpAddr;
		pForwardListCtrl->SetItem( &lv_item );


		//Metric
		sprintf(szMerit, "%d", pIpRouteTable->table[i].dwForwardMetric1);
		lv_item.iSubItem = 4;
		lv_item.pszText = szMerit;
		pForwardListCtrl->SetItem( &lv_item );
    }

    if (pIpAddrTable)
	{
        free(pIpAddrTable);	
		pIpAddrTable = NULL;
	}
    //pForwardListCtrl->EnableWindow(FALSE);
}

BOOL InterfaceIdxToInterfaceIp(PMIB_IPADDRTABLE pIpAddrTable, DWORD dwIndex, char str[])
{
    struct in_addr inadTmp;
    char* szIpAddr;

    if (pIpAddrTable == NULL ||  str == NULL)
        return FALSE;
    str[0] = '\0';
    for (DWORD dwIdx = 0; dwIdx < pIpAddrTable->dwNumEntries; dwIdx++)
    {
        if (dwIndex == pIpAddrTable->table[dwIdx].dwIndex)
        {			
			/*CString ss;
			ss.Format("index = %d", dwIndex);
			AfxMessageBox(ss);*/

            inadTmp.s_addr = pIpAddrTable->table[dwIdx].dwAddr;
            szIpAddr = inet_ntoa(inadTmp);
            if (szIpAddr)
            {
                strcpy(str, szIpAddr);
                return TRUE;
            }
            else
                return FALSE;
			
        }
    }
    return FALSE;

}


//----------------------------------------------------------------------------
// Inputs: pIpAddrTable is the IP address table
//         str is the Interface Ip address in dotted decimal format
// Output: If it returns TRUE, dwIndex contains the interface index number
//         and dwMask contains the corresponding subnet mask.
//----------------------------------------------------------------------------
BOOL InterfaceIpToIdxAndMask(PMIB_IPADDRTABLE pIpAddrTable, char str[], DWORD& dwIndex, DWORD& dwMask)
{
    DWORD dwIfIpAddr; // Interface Ip Address

    if (pIpAddrTable == NULL)
        return FALSE;

    dwIfIpAddr = inet_addr(str);
    if (dwIfIpAddr == INADDR_NONE)
        return FALSE;

    for (DWORD dwIdx = 0; dwIdx < pIpAddrTable->dwNumEntries; dwIdx++)
    {
        if (dwIfIpAddr == pIpAddrTable->table[dwIdx].dwAddr)
        {
            dwIndex = pIpAddrTable->table[dwIdx].dwIndex;
            dwMask = pIpAddrTable->table[dwIdx].dwMask;
            return TRUE;
        }
    }
    return FALSE;
}

//----------------------------------------------------------------------------
// If returned status is NO_ERROR, then pIpAddrTable points to a Ip Address
// table.
//----------------------------------------------------------------------------
DWORD MyGetIpAddrTable(PMIB_IPADDRTABLE& pIpAddrTable, BOOL fOrder)
{
    DWORD status = NO_ERROR;
    DWORD statusRetry = NO_ERROR;
    DWORD dwActualSize = 0;
    
    // query for buffer size needed
    status = GetIpAddrTable(pIpAddrTable, &dwActualSize, fOrder);

    if (status == NO_ERROR)
    {
        //printf("No error\n");
        return status;
    }
    else if (status == ERROR_INSUFFICIENT_BUFFER)
    {
        // need more space
		if( pIpAddrTable != NULL )
		{
			free( pIpAddrTable );
			pIpAddrTable = NULL;
		}	
        pIpAddrTable = (PMIB_IPADDRTABLE) malloc(dwActualSize);
        ASSERT(pIpAddrTable!=NULL);
        
        statusRetry = GetIpAddrTable(pIpAddrTable, &dwActualSize, fOrder);
        return statusRetry;
    }
    else
    {
        return status;
    }
}


//----------------------------------------------------------------------------
// Add an arp entry with ip dotted decimal address of "pszDottedInetAddr" and
// physical address of "pszPhysAddr" in 00-aa-bb-cc-dd-ee format on interface 
// index of "pszInterface" in hex form.
//----------------------------------------------------------------------------
void DoSetIpNetEntry(char* pszDottedInetAddr, char* pszPhysAddr, DWORD index/* = 0*/)
{
    DWORD dwInetAddr = 0; // ip address
    DWORD dwStatus;
    
    if (pszDottedInetAddr == NULL || pszPhysAddr == NULL)
    {
        AfxMessageBox("DoSetIpNetEntry: Bad Argument");
        return;
    }

    dwInetAddr = inet_addr(pszDottedInetAddr); // convert dotted ip addr. to ip addr.
    if (dwInetAddr == INADDR_NONE)
    {
		CString s;
		s.Format("DoSetIpNetEntry: Bad Argument %s\n", pszDottedInetAddr);
        AfxMessageBox(s);
        return;
    }
    
    MIB_IPNETROW arpEntry; // an arp entry
    if ( index == 0 )
    {
        // add this to the first available interface
        PMIB_IPADDRTABLE pIpAddrTable = NULL;
        if ( (dwStatus = MyGetIpAddrTable(pIpAddrTable)) != NO_ERROR)
        {
            AfxMessageBox("DoSetIpNetEntry: Could not find a interface number to add your arp entry");
            return;
        }
        arpEntry.dwIndex = pIpAddrTable->table[0].dwIndex;
        free(pIpAddrTable);
		pIpAddrTable = NULL;
    }
	else
		arpEntry.dwIndex = index;

    arpEntry.dwPhysAddrLen = 6;
    memcpy(arpEntry.bPhysAddr, pszPhysAddr, 6);
    arpEntry.dwAddr = dwInetAddr;
    arpEntry.dwType = MIB_IPNET_TYPE_STATIC; //static arp entry
    dwStatus = SetIpNetEntry(&arpEntry);
    if (dwStatus != NO_ERROR)
    {
		CString s;
        s.Format("IpArp: couldn't add (%s, %s), dwStatus = %lu.\n",
                    pszDottedInetAddr, pszPhysAddr, dwStatus);
		AfxMessageBox(s);
    }
}
//----------------------------------------------------------------------------
// Delete an arp entry with ip dotted decimal address of "pszDottedInetAddr" 
// and interface index of "pszInterface" in hex form.
//----------------------------------------------------------------------------
BOOL DoDeleteIpNetEntry(char* pszDottedInetAddr, DWORD index /*= 0*/)
{
    DWORD dwInetAddr = 0; // ip address
    DWORD dwStatus;

    if (pszDottedInetAddr == NULL)
    {
        AfxMessageBox("DoDeleteIpNetEntry: Bad Argument");
        return FALSE;
    }
    dwInetAddr = inet_addr(pszDottedInetAddr); // convert dotted ip addr. to ip addr.
    if (dwInetAddr == INADDR_NONE)
    {
		CString s;
        s.Format("DoDeleteIpNetEntry: Bad Argument %s\n", pszDottedInetAddr);
		AfxMessageBox(s);
        return FALSE;
    }

    MIB_IPNETROW arpEntry; // an arp entry
    if (index == 0)
    {
        // try to delete this from first available interface
        PMIB_IPADDRTABLE pIpAddrTable = NULL;
        if ( (dwStatus = MyGetIpAddrTable(pIpAddrTable)) != NO_ERROR)
        {
            AfxMessageBox("DoDeleteIpNetEntry: Could not find a interface number to add your arp entry\n");
            return FALSE;
        }
        arpEntry.dwIndex = pIpAddrTable->table[0].dwIndex;
        free(pIpAddrTable);
		pIpAddrTable = NULL;
    }
	else		
		arpEntry.dwIndex = index;
    
    arpEntry.dwAddr = dwInetAddr;
    dwStatus = DeleteIpNetEntry(&arpEntry);
    if (dwStatus != NO_ERROR)
    {
		/*
        CString s;
		s.Format("DoDeleteIpNetEntry: couldn't delete (%s), dwStatus = %lu.\n",
                    pszDottedInetAddr, dwStatus);
		AfxMessageBox(s);
		*/
		return FALSE;
    }

	return TRUE;
}

//----------------------------------------------------------------------------
// Input : fOrder -- sorts the output IP Addr Table
// Output: If it returns NO_ERROR, pIpAddrTable points to the IP Addr Table
//----------------------------------------------------------------------------
DWORD MyGetIpAddrTable(PMIB_IPADDRTABLE& pIpAddrTable, bool fOrder)
{
    DWORD status = NO_ERROR;
    DWORD statusRetry = NO_ERROR;
    DWORD dwActualSize = 0;


    // query for buffer size needed
    status = GetIpAddrTable(pIpAddrTable, &dwActualSize, fOrder);

    if (status == NO_ERROR)
    {
        ////printf("No error\n");
        return status;
    }
    else if (status == ERROR_INSUFFICIENT_BUFFER)
    {
        // need more space

        pIpAddrTable = (PMIB_IPADDRTABLE) malloc(dwActualSize);
        ASSERT(pIpAddrTable);
        
        statusRetry = GetIpAddrTable(pIpAddrTable, &dwActualSize, fOrder);
        return statusRetry;
    }
    else
    {
        return status;
    }
}

BOOL DecideNewGate(DWORD  *GatewayIP, DWORD  *InterfaceIP)
{
	return TRUE;
}


BOOL DecideBestGateway(int nAdaptorIndex, char *BestGatewayIP )
{
	if( NetInterfaceListCtrl == NULL)
		return FALSE;
		
	DWORD   dwGatewayIP;
	
	//get deceit gateway ip: ***.***.***.1 or ***.***.***.2
	if( ( ntohl(inet_addr(AdaptorInfoArray[nAdaptorIndex].IP) )& 0x1 ) != 0) 
	{
		dwGatewayIP = 2;
	}
	else 
		dwGatewayIP = 1;
		
	dwGatewayIP |=  ntohl( inet_addr(AdaptorInfoArray[nAdaptorIndex].IP) ) & 
		            ntohl( inet_addr(AdaptorInfoArray[nAdaptorIndex].Mask) );
	dwGatewayIP = htonl( dwGatewayIP );
	
	strcpy( BestGatewayIP, inet_ntoa( *(struct in_addr *)&dwGatewayIP ));
			
	return TRUE;
}

char* GetDeceitGateway(char *IP, char *mask)
{
	ULONG L1 = ntohl( inet_addr(IP));
	ULONG L2 = ntohl( inet_addr(mask));	
	ULONG hostIPRange = ntohl( inet_addr("255.255.255.255")) - L2;
	ULONG tmp = 0;

#if 1
	if( ( inet_addr(IP) & inet_addr(mask) )== 
		( inet_addr(NPListArray[nSelectedNPIndex].IP) & inet_addr(mask) ) )
	{

		tmp = inet_addr(NPListArray[nSelectedNPIndex].IP);
	}	
	else 
	{
		if( ( L1 & hostIPRange ) == 0x1 )
			tmp = 2;
		else
			tmp = 1;
		tmp |= L1 & L2;
		tmp = htonl( tmp);
			
	}

#else 	
	if( (L1 & 0xff ) == (0xff - 1) ) 
	{
		tmp = ( L1 & 0xffffff00 ) | (0xff - 2);
	}
	else 
		tmp = ( L1 & 0xffffff00 ) | (0xff - 1);

	tmp = htonl( tmp);

#endif
	return inet_ntoa( *(struct in_addr *)&tmp );
}




BOOL GetNetAdaptorInfo2(CListCtrl	*pNetInterfaceListCtrl)
{
	NetInterfaceListCtrl = pNetInterfaceListCtrl;
	char buf[50];

    SOCKET sd = WSASocket(AF_INET, SOCK_DGRAM, 0, 0, 0, 0);
    if (sd == SOCKET_ERROR) 
	{
        AfxMessageBox("Failed to get a socket in MyGetAdaptorInfo!");
		return FALSE;
    }

    INTERFACE_INFO InterfaceList[20];
    unsigned long nBytesReturned;
	LV_ITEM lv_item;
	lv_item.mask = LVIF_TEXT;
	lv_item.cchTextMax = 255;
	
    if (WSAIoctl(sd, SIO_GET_INTERFACE_LIST, NULL, 0, &InterfaceList,
			sizeof(InterfaceList), &nBytesReturned, 0, 0) == SOCKET_ERROR) 
	{
        AfxMessageBox("Failed to gWSAIoctl in MyGetAdaptorInfo!");
		return FALSE;
    }

    int nNumInterfaces = nBytesReturned / sizeof(INTERFACE_INFO);
    //cout << "There are " << nNumInterfaces << " interfaces:" << endl;
    for (int i = 0; i < nNumInterfaces; ++i) 
	{
        sockaddr_in *pAddress;
        pAddress = (sockaddr_in *) & (InterfaceList[i].iiAddress);
        
		if( strcmp( inet_ntoa(pAddress->sin_addr), "127.0.0.1") == 0)
			continue;

		//Description				
	#if 0
		sprintf(buf, "%02d", pNetInterfaceListCtrl->GetItemCount() + 1);
	#else
		buf[0] = 0; 
	#endif 
		lv_item.iItem = pNetInterfaceListCtrl->GetItemCount();
		lv_item.iSubItem = 0;
		lv_item.pszText = buf;
		pNetInterfaceListCtrl->InsertItem( &lv_item );
		
		//IP
		lv_item.iSubItem = 2;
		lv_item.pszText = inet_ntoa(pAddress->sin_addr);
		pNetInterfaceListCtrl->SetItem( &lv_item );
		strcpy( AdaptorInfoArray[lv_item.iItem].IP, inet_ntoa(pAddress->sin_addr) );
	
        
        //Mask
		pAddress = (sockaddr_in *) & (InterfaceList[i].iiNetmask);
		lv_item.iSubItem = 3;
		lv_item.pszText = inet_ntoa(pAddress->sin_addr);
		pNetInterfaceListCtrl->SetItem( &lv_item );        
        strcpy( AdaptorInfoArray[lv_item.iItem].Mask, inet_ntoa(pAddress->sin_addr) );
    }

	if( pNetInterfaceListCtrl->GetItemCount() == 0) 
		return FALSE;
    return TRUE;
}


/********************************
????? 
I dontt know why cant get net table with GetIpNetTable
********************************/
PMIB_IPNETTABLE MyGetIpNetTable()
{
	DWORD status = NO_ERROR;
    DWORD statusRetry = NO_ERROR;
    ULONG dwActualSize = 0;
	PMIB_IPNETTABLE pIPNetTable = NULL;
    
    // query for buffer size needed
    status = GetIpNetTable( NULL, &dwActualSize, TRUE);
    
    if (status == ERROR_INSUFFICIENT_BUFFER)
    {        
        pIPNetTable = (PMIB_IPNETTABLE) malloc(dwActualSize);
        
        statusRetry = GetIpNetTable(pIPNetTable, &dwActualSize, FALSE);
		if( statusRetry == NO_ERROR )
			return pIPNetTable;
		else
		{
			free( pIPNetTable );
			pIPNetTable = NULL;
			return NULL;
		}
    }

    return NULL;
}

void PrintArpTable(PMIB_IPNETTABLE pIpNetTable)
{
    DWORD i, dwStatus, dwCurrIndex;
    struct in_addr inadTmp;
    char szPrintablePhysAddr[256];
    char szType[128];
    char szIpAddr[128];
    PMIB_IPADDRTABLE pIpAddrTable = NULL;
	char Buf[400];
	char TmpBuf[100];

	Buf[0] = 0;
    if (pIpNetTable == NULL)
    {    
        return;
    }
    // get IP Address Table for mapping interface index number to ip address
    if ( (dwStatus = MyGetIpAddrTable(pIpAddrTable)) != NO_ERROR)
    {
        printf("GetIpAddrTable returned 0x%x\n", dwStatus);
        if (pIpAddrTable)
		{
            free(pIpAddrTable);
			pIpAddrTable = NULL;
		}

        return;
    }
    
    // Note: the ARP table should be sorted in interface index
    dwCurrIndex = pIpNetTable->table[0].dwIndex;
    if (InterfaceIdxToInterfaceIp(pIpAddrTable, dwCurrIndex, szIpAddr))
    {
        sprintf(TmpBuf, "\nInterface: %s on Interface 0x%X\n", szIpAddr, dwCurrIndex);
		strcat( Buf, TmpBuf);

        sprintf(TmpBuf, "  Internet Address      Physical Address      Type\n");
		strcat( Buf, TmpBuf);
    }
    else
    {
        sprintf(TmpBuf, "Error: Could not convert Interface number 0x%X to IP address.\n",
                    pIpNetTable->table[0].dwIndex);
		strcat( Buf, TmpBuf);
        return;
    }
    
    
    for (i = 0; i < pIpNetTable->dwNumEntries; ++i)
    {
        if (pIpNetTable->table[i].dwIndex != dwCurrIndex)
        {
            dwCurrIndex = pIpNetTable->table[i].dwIndex;
            if (InterfaceIdxToInterfaceIp(pIpAddrTable, dwCurrIndex, szIpAddr))
            {
                sprintf(TmpBuf, "Interface: %s on Interface 0x%X\n", szIpAddr, dwCurrIndex);
				strcat( Buf, TmpBuf);

                sprintf(TmpBuf, "  Internet Address      Physical Address      Type\n");
				strcat( Buf, TmpBuf);
            }
            else
            {
                printf(TmpBuf, "Error: Could not convert Interface number 0x%X to IP address.\n",
                    pIpNetTable->table[0].dwIndex);
				strcat( Buf, TmpBuf);
                return;
            }
        }
        PhysAddrToString(pIpNetTable->table[i].bPhysAddr, pIpNetTable->table[i].dwPhysAddrLen, szPrintablePhysAddr);
        inadTmp.s_addr = pIpNetTable->table[i].dwAddr;
        switch (pIpNetTable->table[i].dwType)
        {
        case 1:
            strcpy(szType,"other");
            break;
        case 2:
            strcpy(szType,"invalidated");
            break;
        case 3:
            strcpy(szType,"dynamic");
            break;
        case 4: 
            strcpy(szType,"static");
            break;
        default:
            strcpy(szType,"invalidType");
        }
        sprintf(TmpBuf, "  %-16s      %-17s     %-11s\n", inet_ntoa(inadTmp), szPrintablePhysAddr, szType);
		strcat( Buf, TmpBuf);
        
    }
    
	AfxMessageBox(Buf);
}


void GetPhysicalAddressFromArpEntry(char *IP)
{
	PMIB_IPNETTABLE pIPNetTable = NULL;

	pIPNetTable = MyGetIpNetTable();
	PrintArpTable(pIPNetTable);

	free( pIPNetTable );
	pIPNetTable = NULL;
}

BOOL MyGetIpEntry(PMIB_IFROW  pIfEntry)
{
	// query for buffer size needed
    DWORD status = GetIfEntry(pIfEntry);
    if (status == NO_ERROR)
    {        
        return TRUE;
    }

	/*
	char *lpMsgBuf;
	FormatMessage( 
			FORMAT_MESSAGE_ALLOCATE_BUFFER | 
			FORMAT_MESSAGE_FROM_SYSTEM | 
			FORMAT_MESSAGE_IGNORE_INSERTS,
			NULL,
			status,
			MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
						(LPTSTR) &lpMsgBuf,
			0,    NULL );

	AfxMessageBox(lpMsgBuf);
	LocalFree( lpMsgBuf );

    */

	return FALSE;
}


BOOL GetNetAdaptorInfo3(CListCtrl	*pNetInterfaceListCtrl)
{
	PMIB_IPADDRTABLE pIpAddrTable = NULL; 	
	DWORD     dwStatus;
	MIB_IFROW ifEntry;
	CString s;
	char buf[30];

	NetInterfaceListCtrl = pNetInterfaceListCtrl;
	if ( (dwStatus = MyGetIpAddrTable(pIpAddrTable)) != NO_ERROR)
    {
		CString s;
		s.Format("GetIpAddrTable returned 0x%x\n", dwStatus);
        AfxMessageBox(s);
        if (pIpAddrTable)
		{
            free(pIpAddrTable);
			pIpAddrTable = NULL;
		}
        return FALSE;
    }

	LV_ITEM lv_item;
	lv_item.mask = LVIF_TEXT;
	lv_item.cchTextMax = 255;
    
	for (int i = 0; i < (int)pIpAddrTable->dwNumEntries; i++)
    {   			
		ifEntry.dwIndex = pIpAddrTable->table[i].dwIndex;
		s = inet_ntoa( *(struct in_addr *)&pIpAddrTable->table[i].dwAddr);
		if( strcmp( inet_ntoa( *(struct in_addr *)&pIpAddrTable->table[i].dwAddr), 
			        "127.0.0.1" ) == 0) continue;
		MyGetIpEntry(&ifEntry);

		//Description				
		lv_item.iItem = pNetInterfaceListCtrl->GetItemCount();
		lv_item.iSubItem = 0;		
		lv_item.pszText = (char *)ifEntry.bDescr;
		pNetInterfaceListCtrl->InsertItem( &lv_item );


        //Mac
		s = "";
		buf[0] = 0;
        for (UINT kk=0; kk<ifEntry.dwPhysAddrLen; kk++)
        {
            if (kk == (ifEntry.dwPhysAddrLen - 1))
                s.Format("%.2X",(int)ifEntry.bPhysAddr[kk]);
            else
                s.Format("%.2X-",(int)ifEntry.bPhysAddr[kk]);
			strcat(buf, s);
        }
		memcpy( AdaptorInfoArray[lv_item.iItem].Mac, ifEntry.bPhysAddr, 6);
		
		lv_item.iSubItem = 1;
		lv_item.pszText = buf;
		pNetInterfaceListCtrl->SetItem( &lv_item );
		
	  
		//IP			
		lv_item.iSubItem = 2;		
		lv_item.pszText = inet_ntoa( *(struct in_addr *)&pIpAddrTable->table[i].dwAddr);
		pNetInterfaceListCtrl->SetItem( &lv_item );
		strcpy( AdaptorInfoArray[lv_item.iItem].IP, inet_ntoa( *(struct in_addr *)&pIpAddrTable->table[i].dwAddr));
			
		
		//Mask
		lv_item.iSubItem = 3;
		lv_item.pszText = inet_ntoa( *(struct in_addr *)&pIpAddrTable->table[i].dwMask);
		pNetInterfaceListCtrl->SetItem( &lv_item );
		strcpy( AdaptorInfoArray[lv_item.iItem].Mask, inet_ntoa( *(struct in_addr *)&pIpAddrTable->table[i].dwMask) );           
	
	
		AdaptorInfoArray[lv_item.iItem].dwIndex = pIpAddrTable->table[i].dwIndex;
	}
	

	if (pIpAddrTable)
	{
		free(pIpAddrTable);
		pIpAddrTable = NULL;
	}
	return TRUE;        
}

BOOL PhysAddrToString(BYTE PhysAddr[], DWORD PhysAddrLen, char str[])
{
    if (PhysAddr == NULL || PhysAddrLen == 0 || str == NULL)
        return FALSE;
    str[0] = '\0';
    for (DWORD dwIdx = 0; dwIdx < PhysAddrLen; dwIdx++)
    {
        if (dwIdx == PhysAddrLen-1)
            sprintf(str+(dwIdx*3), "%02X", ((int)PhysAddr[dwIdx])&0xff);
        else
            sprintf(str+(dwIdx*3), "%02X-", ((int)PhysAddr[dwIdx])&0xff);
        
    }
    return TRUE;
}
