#include "stdafx.h"

#include "Winsock2.h"
#include "WS2TCPIP.H"
#include "uConfigMain.h"
#include <afxmt.h>

CEvent WaitThreadEndEvent;
BOOL bfKillThread = FALSE; 
//Below three list pointer is actually created outside here
CListCtrl	*NPFindListCtrl = NULL;
CListCtrl	*ForwardListCtrl= NULL;
CListCtrl	*NetInterfaceListCtrl= NULL;

int nWaitUconfigAckTimerID = 0;
int nWaitCloseUconfigAckTimerID = 0;
int nUconfigStatusTimerID = 0;
int nCheckNICIPTimerID = 0;
int nWaitPCIPChangeAckTimerID = 0;


//The buffer for all found compex device
NP_LIST_DATA NPListArray[100];
int  nNPListArrayNum = 0;
int  nSelectedNPIndex = 0;

//The buffer for all network adaptors installed and valid in windows
ADAPTER_INFO AdaptorInfoArray[10];
int  		nNetAdaptorNum = 0;

int listensock[10];
DWORD SocketThreadID; //for compatible with win98/95
HANDLE SocketRecvThreadHandle = NULL;


//Deceit host route for surf compex devices
char DefaultDeceitGateway[20]; 

//If there is one host route in windows route table same with the DefaultDeceitGateway for uConfig.
//Then save its value, then delete it when in uConfig mode. at last recover it if uConfig is terminated
char DefaultHostRouteDest[20];
char DefaultHostRouteMask[20];
char DefaultHostRouteIP[20];
char DefaultHostRouteInterface[20];

BOOL bfFindNP = FALSE;
int  nEnterUconfigMode = UCONFIGMODE_NOTREADY;

static SYSMSG_PACKET sysmsg_packet;

void SetAllList(CListCtrl* pNPFindList, CListCtrl *pForwardListCtrl, CListCtrl	*pNetInterfaceListCtrl);
int CreateSocket(char *BindIP, int BindPort);
int SendData(int socket, char *buf, int len, int dest_port, char *dest_ip);
BOOL CreateAllSocketForEveryNetAdaptor();
int SendNPFindpacket(int AdaptorNo);
int SendUConfigPacket( long cmd, char *DestIP, unsigned char *DestMac, char *SourceIP, unsigned char *SourceMac, char *DeceivingHostGateway, int nAdaptorIndex);
DWORD SocketRecvThread();
unsigned long ProcessNPFindPacket( char *Buf, struct  sockaddr_in FromAddr, int nAdptorIndex);
int ProcessUconfigPacket( char *Buf, struct  sockaddr_in FromAddr);
BOOL IsAlreadyFindNP(char *DeviceMac);
BOOL Run_IPCONFIG( char *CmdParameter);
/********************************************
   Begin Function definition
********************************************/


/******************************************
  All parameter uses host byte order
******************************************/
int CreateSocket(char *BindIP, int BindPort)
{		
	int tmpsock;
	SOCKADDR_IN saUdpCli;
	INT  err;  
	
	tmpsock = socket( AF_INET, SOCK_DGRAM, 0 );
    if ( INVALID_SOCKET == tmpsock )
    {
		AfxMessageBox("Create socket error");
		return 0;
    }
 
#if 0  //Now it is no use for I use ***.***.***.255, not 255.255.255.255
    BOOL fBroadcast = TRUE;
    err = setsockopt ( tmpsock, 
		       SOL_SOCKET,
		       SO_BROADCAST,
		       (CHAR *) &fBroadcast,
		       sizeof ( BOOL )    );

    if ( SOCKET_ERROR == err )
    {
		AfxMessageBox("setsockopt error");
		return 0;
    }
#endif    

	//non-block: asynchronic 
	u_long i = 1;
	int res = ioctlsocket(tmpsock, FIONBIO, &i);
    
    // bind to a local socket and an interface.
    saUdpCli.sin_family = AF_INET;
    saUdpCli.sin_addr.s_addr = inet_addr(BindIP);
    saUdpCli.sin_port = htons( BindPort );

    err = bind ( tmpsock, (SOCKADDR *) &saUdpCli, sizeof (SOCKADDR_IN) );
    if ( SOCKET_ERROR == err )
    {
		AfxMessageBox("Socket Bind Error");
		return 0;
    }     
	
	return tmpsock;
}

int SendData(int socket, char *buf, int len, int dest_port, char *dest_ip)
{
	struct sockaddr_in remotehost;

	if( socket <= 0) return 0;

	remotehost.sin_family = AF_INET;
	remotehost.sin_port =  htons(SYSMSG_UDP_PORT);	
	remotehost.sin_addr.s_addr = inet_addr(dest_ip);

	return sendto(socket, buf, len, 0,(struct sockaddr *)&remotehost,sizeof(remotehost));
}


/***********************************************
  Create socket for every net adaptor
***********************************************/
BOOL CreateAllSocketForEveryNetAdaptor()
{
	memset( listensock, 0, sizeof(listensock) );
	
	for( int i=0; i< nNetAdaptorNum ; i++)
	{
		if( inet_addr( AdaptorInfoArray[i].IP ) != 0) 
		{
			listensock[i] = CreateSocket( AdaptorInfoArray[i].IP, SYSMSG_UDP_PORT);
		}
	}
	return TRUE;
}

void CloseAllSocket()
{
	for( int i=0; i< nNetAdaptorNum ; i++)
	{
		if( listensock[i] != 0) 
			closesocket( listensock[i] );
	}
}


/***********************************************
   Send NP Find packet via one fixed net adaptor.
   Note, If I use the IP of 255.255.255.255, then it will use default 
   gateway to send the broadcast packet via every network adaptor. But 
   the source mac in its mac header in all these packets is the one fixed
   default network adaptor, not the mac of every network adaptor's mac.

   For this reason, here I use the IP of ***.***.***.255, not 255.255.255.255.
   Of course, there will be some problem if compex device receiving the packet
   with socket. It is lucky that now I use mac hook in the compex device to 
   capture the mac. Now every packet's source mac in its mac header will be the 
   its physical mac.
*************************************************/
int SendNPFindpacket(int AdaptorNo)
{	
	//char *DestIP = "255.255.255.255";
	char DestIP[16];
	unsigned char DestMac[] = {0xff, 0xff, 0xff, 0xff, 0xff, 0xff};
	char *DeceitGateway = "0.0.0.0";
	
	if( listensock[AdaptorNo] == 0 ) return 0;

	unsigned long subnet= ntohl( inet_addr(AdaptorInfoArray[AdaptorNo].Mask) );
	unsigned long tmpIP = 0xFFFFFFFF ^ subnet;		
	tmpIP = tmpIP | (  ntohl( inet_addr(AdaptorInfoArray[AdaptorNo].IP) ) & subnet );


	//tmpIP |= 0xff;
	tmpIP = htonl( tmpIP );
	strcpy( DestIP, inet_ntoa( *(struct in_addr *)&tmpIP) );
		
  	return SendUConfigPacket( SYSMSG_CODE_NPFIND_QUERY, 
		                    DestIP, DestMac, 
		                    AdaptorInfoArray[AdaptorNo].IP, AdaptorInfoArray[AdaptorNo].Mac, 
		                    DefaultDeceitGateway, AdaptorNo);	
}



/****************************************************
  send Begin uconfig command to compex device:
    DestIP: compex device ip
	Destmac: compex device mac
	SourceIP: source Adaptor ip
	SourceMac: source Adaptor mac
 Note use the selected net adaptor to send the packet
****************************************************/
int SendUConfigPacket( long cmd, char *DestIP, unsigned char *DestMac, char *SourceIP, unsigned char *SourceMac, char *DeceivingHostGateway, int nAdaptorIndex)
{		
	static SYSMSG_PACKET packet;
	
    memset( (char *)&packet, 0, sizeof (packet) );

    packet.magic_number = htonl(SYSMSG_MAGIC_NUMBER);
    packet.version = htonl(SYSMSG_PROT_VERSION);
    packet.code = htonl(cmd);
	packet.Src_ip = inet_addr(SourceIP);
	packet.Dest_ip = inet_addr(DestIP);	
	memcpy( packet.Src_mac, SourceMac, 6);
	memcpy( packet.Dest_mac, DestMac, 6);  
	packet.Deceiving_Host_gateway = inet_addr( DefaultDeceitGateway );

	return SendData( listensock[nAdaptorIndex], 
		      (char *)&packet, sizeof(packet),
			  SYSMSG_UDP_PORT, DestIP);		

}



/***********************************************
   Recv the reply packet of NP Find packet  
*************************************************/
DWORD SocketRecvThread()
{
	COleDateTime t1 = COleDateTime::GetCurrentTime();	
	COleDateTime t1FristUconfigDetect;
	struct  sockaddr_in FromAddr;
	int     nFromAddrLen = sizeof(FromAddr);	
	struct  timeval timeval;
    int		pktlen;
	char 	RecvBuf[SYSMSG_MSG_MAXLEN];
	int     error;
	unsigned long res ;
	BOOL    bfStopSendNPFindPacket = FALSE;
	int 	nWaitAckTimes = 0;
	
	//clear it
	nNPListArrayNum = 0;
	memset( NPListArray, 0, sizeof( NPListArray ));
		
	timeval.tv_sec = 1;
    timeval.tv_usec = 0;
	WaitThreadEndEvent.ResetEvent();//lock

	while(1)
	{       
        if( bfKillThread ) 
		{
			WaitThreadEndEvent.SetEvent();//unlock
			ExitThread(0);
			//return 0;
		}

		COleDateTime t2 = COleDateTime::GetCurrentTime();
		COleDateTime t = t2 - t1;
		
		if( t.GetSecond() > MAX_DELAY_TIME_FIND_NP ) 
		{	
			bfStopSendNPFindPacket = TRUE;

			if(  nNPListArrayNum == 0 ) 
			{
				//timeout, so regard it as not find compex device			
				AfxGetMainWnd()->SendMessage( WM_NP_FIND, 0, 0);
				WaitThreadEndEvent.SetEvent();//unlock
				ExitThread(0);
			}		
		}        
		
		Sleep(400); //500ms
        
		for( int k=0; k < nNetAdaptorNum; k++)
		{
			if( bfKillThread ) 
			{
				WaitThreadEndEvent.SetEvent();//unlock
				ExitThread(0);
			}
			if( listensock[k] == 0) 
				continue;
		
			memset( RecvBuf, 0, sizeof(RecvBuf) );
			while( ( pktlen = recvfrom(listensock[k], RecvBuf, SYSMSG_MSG_MAXLEN, 0, (struct sockaddr *)&FromAddr, &nFromAddrLen)) != 0) 
			{	
				if( pktlen == -1)
				{
					error = WSAGetLastError();
					break;
				}
				
				res = ProcessNPFindPacket(RecvBuf, FromAddr, k);
				if( res == NPFINDPACKET_NEW )
					AfxGetMainWnd()->SendMessage( WM_NP_FIND, NPFindListCtrl->GetItemCount(), 0);
				else if ( res == NPFINDPACKET_BUT_ALREAYFIND )
					;
				else if( res == FORMAT_ERROR )
					;
				else //already in uConfig Mode
				{
					if( nEnterUconfigMode != UCONFIGMODE_NOTREADY)
					{		
						ProcessUconfigPacket(RecvBuf, FromAddr);
					}
				}
				
				memset( RecvBuf, 0, sizeof(RecvBuf) );
			}
		}
		
		if( !bfStopSendNPFindPacket ) //not time out
		{  //resend the NPFind packet to search compex device
			for( int kkkk = 0; kkkk< nNetAdaptorNum; kkkk++)
				SendNPFindpacket(kkkk);
		}

		if(  nEnterUconfigMode != UCONFIGMODE_NOTREADY && 
			 nEnterUconfigMode != UCONFIGMODE_ACKED )
		{
			nWaitAckTimes ++; 
			
			SendUConfigPacket(  SYSMSG_CODE_BEGIN_UCONFIG, 
							  	NPListArray[ nSelectedNPIndex ].IP, 
					   			NPListArray[ nSelectedNPIndex ].Mac, 
					   			AdaptorInfoArray[ CURRENT_ADAPTOR_INDEX ].IP,
					   			AdaptorInfoArray[ CURRENT_ADAPTOR_INDEX ].Mac, 
					   			DefaultDeceitGateway, 
					   			CURRENT_ADAPTOR_INDEX);
			if( nWaitAckTimes > 100) //maybe there are something wrong with the device, so regard it have
			                     //received the ack respond
				nWaitAckTimes = TRUE;
		}
		else
			nWaitAckTimes = 0;

		
	}


	WaitThreadEndEvent.SetEvent();//unlock
	ExitThread(0);
}


unsigned long ProcessNPFindPacket( char *Buf, struct  sockaddr_in FromAddr, int nAdptorIndex)
{
	LV_ITEM lv_item;
	char tmpIP[20];	
	char buf[100];	
	SYSMSG_PACKET * p_sysmsg_packet;
    
	p_sysmsg_packet = (SYSMSG_PACKET *) Buf;

    if ( p_sysmsg_packet->magic_number != htonl(SYSMSG_MAGIC_NUMBER) ||
         p_sysmsg_packet->version == 0  ||
		p_sysmsg_packet->code == htonl(SYSMSG_CODE_NPFIND_QUERY) ) /* This is loopback packet */
	{		
		return FORMAT_ERROR;
    }
		
	if( p_sysmsg_packet->code == htonl(SYSMSG_CODE_NPFIND_REPLY) ) 
	{   //already exist
		if( IsAlreadyFindNP((char *)p_sysmsg_packet->Src_mac) )
			return ( NPFINDPACKET_BUT_ALREAYFIND );
		
		strcpy(tmpIP, inet_ntoa( *(struct in_addr *)&p_sysmsg_packet->ip_address ));
		
		//store infomation
		strcpy( NPListArray[ nNPListArrayNum ].IP, tmpIP );
		NPListArray[ nNPListArrayNum ].uConfigVersion = ntohl( p_sysmsg_packet->version );
		if( p_sysmsg_packet->version != ntohl(1) )
			memcpy( NPListArray[nNPListArrayNum ].Mac, p_sysmsg_packet->Src_mac, 6 );
		if( p_sysmsg_packet->version >= ntohl(SYSMSG_PROT_VERSION) )
		{
			NPListArray[nNPListArrayNum ].bfUconfigMode = p_sysmsg_packet->bfUconfigMode;
		}
		strcpy( NPListArray[nNPListArrayNum ].product_model, p_sysmsg_packet->product_model);
		strcpy( NPListArray[nNPListArrayNum ].system_name, p_sysmsg_packet->system_name); 
		NPListArray[nNPListArrayNum ].AdatptorIndex = nAdptorIndex;
		
		nNPListArrayNum ++;
		
		lv_item.mask = LVIF_TEXT;
		lv_item.cchTextMax = 255;
		//product model
		lv_item.iItem = NPFindListCtrl->GetItemCount();
		lv_item.iSubItem = 0;
	#if 0
		sprintf(buf, "%02d  ", lv_item.iItem + 1);
	#else		
		buf[0] = 0; 	
	#endif
		strcat(buf, p_sysmsg_packet->product_model);
		lv_item.pszText = buf;
		NPFindListCtrl->InsertItem( &lv_item );
				
		if( ntohl(p_sysmsg_packet->version ) >= 2) 
			memcpy( NPListArray[lv_item.iItem].Mac, p_sysmsg_packet->Src_mac, 6);

		//system name
		lv_item.iSubItem = 1;
		lv_item.pszText = p_sysmsg_packet->system_name;
		NPFindListCtrl->SetItem( &lv_item );
    
		//MAC
		lv_item.iSubItem = 2;
		if( p_sysmsg_packet->version != ntohl(1) )
		{			
			sprintf(buf,"%02x-%02x-%02x-%02x-%02x-%02x",
				p_sysmsg_packet->Src_mac[0], p_sysmsg_packet->Src_mac[1], p_sysmsg_packet->Src_mac[2],
				p_sysmsg_packet->Src_mac[3], p_sysmsg_packet->Src_mac[4], p_sysmsg_packet->Src_mac[5]);						
			lv_item.pszText = buf;
			NPFindListCtrl->SetItem( &lv_item );			
		}

		//IP
		lv_item.iSubItem = 3;
		lv_item.pszText = tmpIP;
		NPFindListCtrl->SetItem( &lv_item );

		//Memo		
		lv_item.iSubItem = 4;
		if( NPListArray[lv_item.iItem ].bfUconfigMode == 0)
			lv_item.pszText = "";
		else 
			lv_item.pszText = "*";
		NPFindListCtrl->SetItem( &lv_item );
							
		return NPFINDPACKET_NEW;
	}		
    
	return ( ntohl( p_sysmsg_packet->code ));
}



/***********************************************
   Recv the reply packet of NP Find packet: 
      main receive the packet from compex device for 
	    1) its Lan port ip report
		2) the report that the compex has exit Uconfig mode

*************************************************/
int ProcessUconfigPacket( char *Buf, struct  sockaddr_in FromAddr)
{	
    SYSMSG_PACKET *p_sysmsg_packet =  (SYSMSG_PACKET *) Buf;

    if ( p_sysmsg_packet->magic_number != htonl(SYSMSG_MAGIC_NUMBER) ||
          p_sysmsg_packet->version == 0 || 
	   ( memcmp( p_sysmsg_packet->Src_mac, NPListArray[nSelectedNPIndex].Mac, 6) != 0 ) )//not the device
	{        
		return FORMAT_ERROR;
    }

	//check if the packet is from the corect compex device
	/*reason why not check ip: device and PC's ip will be changed */
	if( memcmp(p_sysmsg_packet->Src_mac, NPListArray[nSelectedNPIndex].Mac, 6) != 0 ||
		memcmp(p_sysmsg_packet->Dest_mac, AdaptorInfoArray[CURRENT_ADAPTOR_INDEX].Mac, 6) != 0 /*||
		p_sysmsg_packet->Src_ip != inet_addr( NPListArray[nSelectedNPIndex].IP ) || 
		p_sysmsg_packet->Dest_ip != inet_addr(AdaptorInfoArray[CURRENT_ADAPTOR_INDEX].IP) */
		)
		return FORMAT_ERROR;
			
		
	if( p_sysmsg_packet->code == htonl(SYSMSG_CODE_CHANGE_IP) )
	{ //the compex device's ip is changed.        
		/*Tell Compex device that the IP_Change info has received */
		SendUConfigPacket( SYSMSG_CODE_CHANGE_IP_ACK, NPListArray[nSelectedNPIndex].IP, 
					   NPListArray[nSelectedNPIndex].Mac, 
					   AdaptorInfoArray[CURRENT_ADAPTOR_INDEX].IP,
					   AdaptorInfoArray[CURRENT_ADAPTOR_INDEX].Mac, DefaultDeceitGateway, CURRENT_ADAPTOR_INDEX);
		if( p_sysmsg_packet->ip_address != inet_addr(NPListArray[nSelectedNPIndex].IP) ) 
		{			
			//Only need to update host route table item, but not arp item
			DoDeleteIpForwardEntry( NPListArray[nSelectedNPIndex].IP );
		
			//renew related information				
			strcpy( NPListArray[nSelectedNPIndex].IP, inet_ntoa( *(struct in_addr *)&p_sysmsg_packet->ip_address) );
			
			LV_ITEM lv_item;

			lv_item.mask = LVIF_TEXT;
			lv_item.cchTextMax = 255;
			lv_item.iItem = nSelectedNPIndex;
			lv_item.iSubItem = 3;
			lv_item.pszText = NPListArray[nSelectedNPIndex].IP;
			NPFindListCtrl->SetItem( &lv_item );

			DoSetIpForwardEntry(NPListArray[nSelectedNPIndex].IP, "255.255.255.255", DefaultDeceitGateway, AdaptorInfoArray[CURRENT_ADAPTOR_INDEX].IP,1);
		
	#if 0	/*20002.07.12 */
			if( Run_IPCONFIG(" /release") )
			{				
				if( 1)//Run_IPCONFIG(" /renew") )
				{
					//Sleep(500);
					AfxGetMainWnd()->SendMessage( WM_CHECK_PC_IP, 0, 0);
				}
				else 
					AfxMessageBox("ipconfg renew error");
			}
			else
				AfxMessageBox("ipconfg.exe release error");
	#endif				
		}		
	}
	else if( p_sysmsg_packet->code == htonl( SYSMSG_CODE_BEGIN_UCONFIG_ACK) )
	{ //the compex device reply the begin uconfig command with acknolodge
		
		nEnterUconfigMode = UCONFIGMODE_ACKED;
				
		AfxGetMainWnd()->SendMessage( WM_BEGIN_UCONFIG_ACK, 0, 0);
    }
	else if( p_sysmsg_packet->code == htonl( SYSMSG_CODE_BEGIN_UCONFIG_DENY) )
	{ //the compex device reply the begin uconfig command with acknolodge
		//uConfig is denied by compex device
		nEnterUconfigMode = UCONFIGMODE_DENIED;

		AfxGetMainWnd()->SendMessage( WM_BEGIN_UCONFIG_DENY, 0, 0);
		 
    }	
	else if( p_sysmsg_packet->code == htonl( SYSMSG_CODE_NEED_NEW_ARP) )
	{ //the compex device reply the begin uconfig command with acknolodge
		DoDeleteIpNetEntry( DefaultDeceitGateway, AdaptorInfoArray[CURRENT_ADAPTOR_INDEX].dwIndex );
		//Set deceving arp item in the arp table 
		DoSetIpNetEntry(DefaultDeceitGateway, (char *)NPListArray[nSelectedNPIndex].Mac,AdaptorInfoArray[CURRENT_ADAPTOR_INDEX].dwIndex );
	}
	else if( p_sysmsg_packet->code == htonl(SYSMSG_CODE_CLOSE_UCONFIG) )
	{	//Device exit uconfig with http 		
		AfxGetMainWnd()->PostMessage( WM_CLOSE, 0, 0);
				
		return ( ntohl( p_sysmsg_packet->code ));
	}
	else if( p_sysmsg_packet->code == htonl(SYSMSG_CODE_CLOSE_UCONFIG_ACK) )
	{					
		return ( ntohl( p_sysmsg_packet->code ));
	}
	else if( p_sysmsg_packet->code == htonl(SYSMSG_CODE_PC_IP_CHANGED_ACK) )
	{
		AfxGetMainWnd()->SendMessage( WM_PC_IP_CHANGE_ACK, 0, 0);
	}
	
	
	return ( ntohl( p_sysmsg_packet->code ));
}


void SetAllList(CListCtrl* pNPFindList, CListCtrl *pForwardListCtrl, CListCtrl *pNetInterfaceListCtrl)
{
	NPFindListCtrl = pNPFindList;
	ForwardListCtrl= pForwardListCtrl; 
	NetInterfaceListCtrl= pNetInterfaceListCtrl; 
	
	WaitThreadEndEvent.SetEvent();//unlock
}

BOOL BeginNPFind() 
{
	nNetAdaptorNum = NetInterfaceListCtrl->GetItemCount();
	CreateAllSocketForEveryNetAdaptor();

	if( (SocketRecvThreadHandle = CreateThread( NULL, 20000, (LPTHREAD_START_ROUTINE )SocketRecvThread,NULL, 0, &SocketThreadID) )== NULL )
	{
		AfxMessageBox("Cannot create thread in BeginNPFind");
		return FALSE;
	}

	for( int kkkk = 0; kkkk< nNetAdaptorNum; kkkk++)
		SendNPFindpacket(kkkk);
	
	return TRUE;
}

void ExitNP_UConfig()
{
	bfKillThread = TRUE;
	
	if( WaitForSingleObject( WaitThreadEndEvent.m_hObject, 15000) ==  WAIT_TIMEOUT )
	{
		TerminateThread( SocketRecvThreadHandle , 0);
	}		
	
	CloseAllSocket();

	if( pFixedInfo != NULL )
		free( pFixedInfo );

	if( pNetAdapterInfo != NULL )
		free( pNetAdapterInfo);

	//if( pIpRouteTab != NULL )
	//	free( pIpRouteTab );
	
	//CloseHandle( WaitThreadEndEvent.m_hObject ); //Note, It is error if use this closeHanle. For the object
	                                          //is not created with create mode
}


BOOL IsAlreadyFindNP(char *DeviceMac)
{
	for( int i=0; i<nNPListArrayNum; i++)
	{
		if( memcmp( NPListArray[i].Mac, DeviceMac, 6) == 0 )
			return TRUE;			
	}

	return FALSE;
}


/**************************************
If check ok, then return NULL
else return the error string
****************************************/

char *CheckDeviceVersion( int nSelectedNPIndex)
{
	static char Error[100];
	
	if( nSelectedNPIndex <0 || nSelectedNPIndex >= nNPListArrayNum)
	{
		strcpy(Error, "Selected Compex Device Error, Please Select Again!");
		return Error;
	}
	
	if( NPListArray[nSelectedNPIndex].uConfigVersion < SYSMSG_PROT_VERSION ) 
	{
		strcpy(Error, "The firmware in the selected ");
		strcat( Error, NPListArray[nSelectedNPIndex].product_model);
		strcat( Error, " does not support this uConfig v2.2 or higher. Please use the earlier uConfig v1.22. Pls upgrade to a newer firmware to use uConfig v2.2!");
			return Error;
	}

	return NULL;
}

char *GetDeviceProductName( int nSelectedNPIndex)
{
	return NPListArray[nSelectedNPIndex].product_model;
}

void GetMemoString( int nSelectedNPIndex, char *BufString)
{
	if( (NPListArray[nSelectedNPIndex].bfUconfigMode == 1) ||
		( nSelectedNPIndex == nSelectedNPIndex && nEnterUconfigMode == UCONFIGMODE_ACKED ) )
		strcpy(BufString, "* ");		
	else 
		BufString[0] = 0;
		
}

BOOL Run_IPCONFIG( char *CmdParameter)
{
	PROCESS_INFORMATION piProcInfo;
	STARTUPINFO siStartupInfo;
	char systemDir[200]; 
	char FileName[200];		
	
	systemDir[0] = 0;
	GetSystemDirectory(systemDir, sizeof(systemDir));
	if( strlen(systemDir) == 0) 
	{
		AfxMessageBox("System Directory error");
		AfxGetMainWnd()->PostMessage(WM_CLOSE);
		return FALSE;
	}
	strcpy(FileName, systemDir);
	strcat(FileName, "\\ipconfig.exe");
	
	siStartupInfo.cb = sizeof(STARTUPINFO);
	siStartupInfo.lpReserved = NULL;
	siStartupInfo.lpDesktop = NULL;
	siStartupInfo.lpTitle = NULL;
	siStartupInfo.dwFlags = STARTF_USESHOWWINDOW;
	siStartupInfo.wShowWindow = SW_MINIMIZE; //SW_NORMAL ;//SW_MINIMIZE;
	siStartupInfo.cbReserved2 = 0;
	siStartupInfo.lpReserved2 = NULL;

	if( AfxGetMainWnd()->FindWindow(NULL, FileName) != NULL )
	{
		//AfxMessageBox("Find");
		return TRUE;
	}		
	
	if( CreateProcess( FileName, CmdParameter, NULL, NULL, TRUE, NORMAL_PRIORITY_CLASS, NULL, NULL, &siStartupInfo, &piProcInfo ) == 0)
	{
		CString s;
		s.Format("The system file ipconfig.exe /%s not find in the directory %d", CmdParameter, systemDir);
		AfxMessageBox(s);
		AfxGetMainWnd()->PostMessage(WM_CLOSE);
		return FALSE;
	}		

	return TRUE;
}